/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.PrintWriter;
import java.util.Objects;

class AnnotatedMethod {
    private final String className;
    private final String methodName;
    private final String descriptor;

    AnnotatedMethod(String className, String methodName, String descriptor) {
        this.className = className;
        this.methodName = methodName;
        this.descriptor = descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotatedMethod)) {
            return false;
        }
        AnnotatedMethod that = (AnnotatedMethod)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.descriptor);
    }

    void save(PrintWriter writer, String separator) {
        writer.println(this.className + separator + this.methodName + separator + this.descriptor);
    }

    static AnnotatedMethod parseReadLine(String s, String separator) {
        String[] arr = s.split(separator);
        if (arr.length != 3) {
            throw new IllegalArgumentException(s);
        }
        return new AnnotatedMethod(arr[0], arr[1], arr[2]);
    }

    String getClassName() {
        return this.className;
    }

    String getMethodName() {
        return this.methodName;
    }

    String getDescriptor() {
        return this.descriptor;
    }
}

