/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spatial;

import org.hibernate.search.util.common.impl.Contracts;

public enum DistanceUnit {
    METERS(1.0),
    KILOMETERS(1000.0),
    MILES(1609.344),
    YARDS(0.9144),
    NAUTICAL_MILES(1852.0);

    private final double toMeters;

    private DistanceUnit(double toMeters) {
        this.toMeters = toMeters;
    }

    public double toMeters(double distance) {
        Contracts.assertNotNull((Object)distance, (String)"distance");
        return distance * this.toMeters;
    }

    public Double fromMeters(Double distanceInMeters) {
        if (distanceInMeters == null) {
            return null;
        }
        return distanceInMeters / this.toMeters;
    }
}

