/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.util.DateHelper;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.jboss.logging.Logger;

public abstract class ObjectPropertyHelper<TypeMetadata> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ObjectPropertyHelper.class.getName());
    protected static final Map<Class<?>, Class<?>> primitives = new HashMap();

    protected ObjectPropertyHelper() {
    }

    public abstract TypeMetadata getEntityMetadata(String var1);

    public Object convertToPropertyType(TypeMetadata entityType, String[] propertyPath, String value) {
        Class<?> propertyType = this.getPrimitivePropertyType(entityType, propertyPath);
        if (propertyType == null) {
            throw log.getPredicatesOnCompleteEmbeddedEntitiesNotAllowedException(StringHelper.join(propertyPath));
        }
        return this.convertToPropertyType(propertyType, value);
    }

    public Object convertToPropertyType(Class<?> propertyType, String value) {
        if (Date.class.isAssignableFrom(propertyType)) {
            try {
                return DateHelper.getJpaDateFormat().parse(value);
            }
            catch (ParseException e) {
                throw log.getInvalidDateLiteralException(value);
            }
        }
        if (Instant.class.isAssignableFrom(propertyType)) {
            return Instant.parse(value);
        }
        if (Enum.class.isAssignableFrom(propertyType)) {
            try {
                return Enum.valueOf(propertyType, value);
            }
            catch (IllegalArgumentException e) {
                throw log.getInvalidEnumLiteralException(value, propertyType.getName());
            }
        }
        if (propertyType == String.class) {
            return value;
        }
        if (propertyType == Character.class || propertyType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        try {
            if (propertyType == Double.class || propertyType == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (propertyType == Float.class || propertyType == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (propertyType == Long.class || propertyType == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (propertyType == Integer.class || propertyType == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (propertyType == Short.class || propertyType == Short.TYPE) {
                return Short.valueOf(value);
            }
            if (propertyType == Byte.class || propertyType == Byte.TYPE) {
                return Byte.valueOf(value);
            }
        }
        catch (NumberFormatException ex) {
            throw log.getInvalidNumericLiteralException(value);
        }
        if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            throw log.getInvalidBooleanLiteralException(value);
        }
        return value;
    }

    public abstract Class<?> getPrimitivePropertyType(TypeMetadata var1, String[] var2);

    public Class<?> getIndexedPropertyType(TypeMetadata entityType, String[] propertyPath) {
        return null;
    }

    public boolean isNestedIndexStructure(TypeMetadata entityType, String[] propertyPath) {
        return false;
    }

    public abstract boolean hasProperty(TypeMetadata var1, String[] var2);

    public abstract boolean hasEmbeddedProperty(TypeMetadata var1, String[] var2);

    public abstract boolean isRepeatedProperty(TypeMetadata var1, String[] var2);

    public abstract IndexedFieldProvider<TypeMetadata> getIndexedFieldProvider();

    public abstract List<?> mapPropertyNamePathToFieldIdPath(TypeMetadata var1, String[] var2);

    public Object convertToBackendType(TypeMetadata entityType, String[] propertyPath, Object value) {
        return value;
    }

    static {
        primitives.put(Date.class, Date.class);
        primitives.put(Instant.class, Instant.class);
        primitives.put(String.class, String.class);
        primitives.put(Character.class, Character.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Double.class, Double.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.class, Float.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Long.class, Long.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Integer.class, Integer.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Short.class, Short.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Byte.class, Byte.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Boolean.class, Boolean.class);
        primitives.put(Boolean.TYPE, Boolean.class);
    }
}

