/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.GenericPayload;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Messages;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.providers.AbstractMediator;
import io.smallrye.reactive.messaging.providers.helpers.AcknowledgementCoordinator;
import io.smallrye.reactive.messaging.providers.helpers.ClassUtils;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;

public class ProcessorMediator
extends AbstractMediator {
    private Function<Multi<? extends Message<?>>, Multi<? extends Message<?>>> mapper;
    private Multi<? extends Message<?>> publisher;

    public ProcessorMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.shape() != Shape.PROCESSOR) {
            throw ProviderExceptions.ex.illegalArgumentForProcessorShape(configuration.shape());
        }
        if (configuration.production() == MediatorConfiguration.Production.STREAM_OF_MESSAGE && configuration.consumption() == MediatorConfiguration.Consumption.PAYLOAD) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayload(configuration.methodAsString());
        }
        if (configuration.production() == MediatorConfiguration.Production.STREAM_OF_PAYLOAD && configuration.consumption() == MediatorConfiguration.Consumption.MESSAGE) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessage(configuration.methodAsString());
        }
    }

    @Override
    public void connectToUpstream(Multi<? extends Message<?>> publisher) {
        assert (this.mapper != null);
        this.publisher = this.decorate(publisher.plug(m -> this.mapper.apply(this.convert((Multi<? extends Message<?>>)m))));
    }

    @Override
    public Multi<? extends Message<?>> getStream() {
        return Objects.requireNonNull(this.publisher);
    }

    @Override
    public boolean isConnected() {
        return this.publisher != null;
    }

    @Override
    protected <T> Uni<T> invokeBlocking(Message<?> message, Object ... args) {
        return super.invokeBlocking(message, args);
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.production()) {
            case STREAM_OF_MESSAGE: {
                if (this.isReturningAProcessorOrAReactiveStreamsProcessorOrAProcessorBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAProcessorBuilderOfMessages();
                        break;
                    }
                    if (this.configuration.usesReactiveStreams()) {
                        this.processMethodReturningAReactiveStreamsProcessorOfMessages();
                        break;
                    }
                    this.processMethodReturningAProcessorOfMessages();
                    break;
                }
                if (this.isReturningAPublisherOrAReactiveStreamsPublisherOrAPublisherBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAPublisherBuilderOfMessageAndConsumingMessages();
                        break;
                    }
                    if (this.configuration.usesReactiveStreams()) {
                        this.processMethodReturningAReactiveStreamsPublisherOfMessageAndConsumingMessages();
                        break;
                    }
                    this.processMethodReturningAPublisherOfMessageAndConsumingMessages();
                    break;
                }
                throw ProviderExceptions.ex.illegalArgumentForInitialize(this.configuration.methodAsString());
            }
            case STREAM_OF_PAYLOAD: {
                if (this.isReturningAProcessorOrAReactiveStreamsProcessorOrAProcessorBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAProcessorBuilderOfPayloads();
                        break;
                    }
                    if (this.configuration.usesReactiveStreams()) {
                        this.processMethodReturningAReactiveStreamsProcessorOfPayloads();
                        break;
                    }
                    this.processMethodReturningAProcessorOfPayloads();
                    break;
                }
                if (this.isReturningAPublisherOrAReactiveStreamsPublisherOrAPublisherBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAPublisherBuilderOfPayloadsAndConsumingPayloads();
                        break;
                    }
                    if (this.configuration.usesReactiveStreams()) {
                        this.processMethodReturningAReactiveStreamsPublisherOfPayloadsAndConsumingPayloads();
                        break;
                    }
                    this.processMethodReturningAPublisherOfPayloadsAndConsumingPayloads();
                    break;
                }
                throw ProviderExceptions.ex.illegalArgumentForInitialize(this.configuration.methodAsString());
            }
            case INDIVIDUAL_MESSAGE: {
                this.processMethodReturningIndividualMessageAndConsumingIndividualItem();
                break;
            }
            case INDIVIDUAL_PAYLOAD: {
                this.processMethodReturningIndividualPayloadAndConsumingIndividualItem();
                break;
            }
            case COMPLETION_STAGE_OF_MESSAGE: {
                this.processMethodReturningACompletionStageOfMessageAndConsumingIndividualItem();
                break;
            }
            case COMPLETION_STAGE_OF_PAYLOAD: {
                this.processMethodReturningACompletionStageOfPayloadAndConsumingIndividualItem();
                break;
            }
            case UNI_OF_MESSAGE: {
                this.processMethodReturningAUniOfMessageAndConsumingIndividualItem();
                break;
            }
            case UNI_OF_PAYLOAD: {
                this.processMethodReturningAUniOfPayloadAndConsumingIndividualItem();
                break;
            }
            default: {
                throw ProviderExceptions.ex.illegalArgumentForUnexpectedProduction(this.configuration.production());
            }
        }
    }

    private void processMethodReturningAPublisherBuilderOfMessageAndConsumingMessages() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(msg -> AdaptersToFlow.publisher((Publisher)((PublisherBuilder)this.invoke(msg)).buildRs()));
    }

    private void processMethodReturningAReactiveStreamsPublisherOfMessageAndConsumingMessages() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(msg -> AdaptersToFlow.publisher((Publisher)((Publisher)this.invoke(msg))));
    }

    private void processMethodReturningAPublisherOfMessageAndConsumingMessages() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(msg -> (Flow.Publisher)this.invoke(msg));
    }

    private void processMethodReturningAProcessorBuilderOfMessages() {
        ProcessorBuilder builder = Objects.requireNonNull((ProcessorBuilder)this.invoke(new Object[0]), ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
        this.mapper = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return MultiUtils.via(multi, AdaptersToFlow.processor((Processor)builder.buildRs()));
        };
    }

    private void processMethodReturningAReactiveStreamsProcessorOfMessages() {
        Processor result = Objects.requireNonNull((Processor)this.invoke(new Object[0]), ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
        this.mapper = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return MultiUtils.via(multi, AdaptersToFlow.processor((Processor)result));
        };
    }

    private void processMethodReturningAProcessorOfMessages() {
        Flow.Processor result = Objects.requireNonNull((Flow.Processor)this.invoke(new Object[0]), ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
        this.mapper = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return MultiUtils.via(multi, result);
        };
    }

    private void processMethodReturningAProcessorBuilderOfPayloads() {
        ProcessorBuilder returnedProcessorBuilder = (ProcessorBuilder)this.invoke(new Object[0]);
        Objects.requireNonNull(returnedProcessorBuilder, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
        this.mapper = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            return MultiUtils.via(multi, AdaptersToFlow.processor((Processor)returnedProcessorBuilder.buildRs())).onItem().transform(this::payloadToMessage);
        };
    }

    private void processMethodReturningAReactiveStreamsProcessorOfPayloads() {
        Processor returnedProcessor = (Processor)this.invoke(new Object[0]);
        Objects.requireNonNull(returnedProcessor, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
        this.mapper = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            return MultiUtils.via(multi, AdaptersToFlow.processor((Processor)returnedProcessor)).onItem().transform(this::payloadToMessage);
        };
    }

    private void processMethodReturningAProcessorOfPayloads() {
        Flow.Processor returnedProcessor = (Flow.Processor)this.invoke(new Object[0]);
        Objects.requireNonNull(returnedProcessor, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
        this.mapper = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            return MultiUtils.via(multi, returnedProcessor).onItem().transform(this::payloadToMessage);
        };
    }

    private void processMethodReturningAPublisherBuilderOfPayloadsAndConsumingPayloads() {
        this.mapper = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return multi.onItem().transformToMultiAndConcatenate(message -> {
                if (this.isPostAck()) {
                    try {
                        PublisherBuilder pb = (PublisherBuilder)this.invoke(this.getArguments(message));
                        AcknowledgementCoordinator coordinator = new AcknowledgementCoordinator((Message<?>)message);
                        return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)pb.buildRs())).onItem().transform(payload -> coordinator.track(this.payloadToMessage(payload, message.getMetadata())));
                    }
                    catch (Throwable t) {
                        return this.handlePostInvocation((Message<?>)message, t);
                    }
                }
                PublisherBuilder pb = (PublisherBuilder)this.invoke(this.getArguments(message));
                return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)pb.buildRs())).onItem().transform(payload -> this.payloadToMessage(payload, message.getMetadata()));
            });
        };
    }

    private void processMethodReturningAReactiveStreamsPublisherOfPayloadsAndConsumingPayloads() {
        this.mapper = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return multi.onItem().transformToMultiAndConcatenate(message -> {
                if (this.isPostAck()) {
                    try {
                        Publisher pub = (Publisher)this.invoke(this.getArguments(message));
                        AcknowledgementCoordinator coordinator = new AcknowledgementCoordinator((Message<?>)message);
                        return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)pub)).onItem().transform(payload -> coordinator.track(this.payloadToMessage(payload, message.getMetadata())));
                    }
                    catch (Throwable t) {
                        return this.handlePostInvocation((Message<?>)message, t);
                    }
                }
                Publisher pub = (Publisher)this.invoke(this.getArguments(message));
                return MultiUtils.publisher(AdaptersToFlow.publisher((Publisher)pub)).onItem().transform(payload -> this.payloadToMessage(payload, message.getMetadata()));
            });
        };
    }

    private void processMethodReturningAPublisherOfPayloadsAndConsumingPayloads() {
        this.mapper = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return multi.onItem().transformToMultiAndConcatenate(message -> {
                if (this.isPostAck()) {
                    try {
                        Flow.Publisher pub = (Flow.Publisher)this.invoke(this.getArguments(message));
                        AcknowledgementCoordinator coordinator = new AcknowledgementCoordinator((Message<?>)message);
                        return MultiUtils.publisher(pub).onItem().transform(payload -> coordinator.track(this.payloadToMessage(payload, message.getMetadata())));
                    }
                    catch (Throwable t) {
                        return this.handlePostInvocation((Message<?>)message, t);
                    }
                }
                Flow.Publisher pub = (Flow.Publisher)this.invoke(this.getArguments(message));
                return MultiUtils.publisher(pub).onItem().transform(payload -> this.payloadToMessage(payload, message.getMetadata()));
            });
        };
    }

    private void processMethodReturningIndividualMessageAndConsumingIndividualItem() {
        this.mapper = this.configuration.isBlocking() ? (this.configuration.isBlockingExecutionOrdered() ? upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return multi.onItem().transformToMultiAndConcatenate(message -> this.invokeBlocking((Message<?>)message, this.getArguments(message)).onItemOrFailure().transformToUni((o, t) -> this.handlePostInvocationWithMessage((Message<?>)message, (Message<?>)((Message)o), (Throwable)t)).onItem().transformToMulti(this::handleSkip));
        } : upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return multi.onItem().transformToMulti(message -> this.invokeBlocking((Message<?>)message, this.getArguments(message)).onItemOrFailure().transformToUni((o, t) -> this.handlePostInvocationWithMessage((Message<?>)message, (Message<?>)((Message)o), (Throwable)t)).onItem().transformToMulti(this::handleSkip)).merge(this.maxConcurrency());
        }) : upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            return multi.onItem().transformToMultiAndConcatenate(message -> this.invokeOnMessageContext((Message<?>)message, this.getArguments(message)).onItem().transform(o -> (Message)o).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocationWithMessage((Message<?>)message, (Message<?>)r, (Throwable)f)).onItem().transformToMulti(this::handleSkip));
        };
    }

    private void processMethodReturningIndividualPayloadAndConsumingIndividualItem() {
        this.mapper = this.configuration.isBlocking() ? (this.configuration.isBlockingExecutionOrdered() ? upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(message -> this.invokeBlocking((Message<?>)message, this.getArguments(message)).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocation((Message<?>)message, r, (Throwable)f)).onItem().transformToMulti(this::handleSkip)) : upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMulti(message -> this.invokeBlocking((Message<?>)message, this.getArguments(message)).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocation((Message<?>)message, r, (Throwable)f)).onItem().transformToMulti(this::handleSkip)).merge(this.maxConcurrency())) : upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(message -> this.invokeOnMessageContext((Message<?>)message, this.getArguments(message)).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocation((Message<?>)message, r, (Throwable)f)).onItem().transformToMulti(this::handleSkip));
    }

    private Flow.Publisher<? extends Message<Object>> handleSkip(Message<Object> m) {
        if (m == null) {
            return Multi.createFrom().empty();
        }
        return Multi.createFrom().item(m);
    }

    private Multi<? extends Message<?>> handlePostInvocation(Message<?> message, Throwable fail) {
        return Uni.createFrom().completionStage(() -> message.nack(fail).thenApply(x -> null)).toMulti();
    }

    private Uni<? extends Message<Object>> handlePostInvocation(Message<?> message, Object res, Throwable fail) {
        if (fail != null) {
            if (this.isPostAck()) {
                return Uni.createFrom().completionStage(message.nack(fail).thenApply(x -> null));
            }
            throw ProviderExceptions.ex.processingException(this.getMethodAsString(), fail);
        }
        if (res != null) {
            if (res instanceof GenericPayload) {
                GenericPayload genericPayload = (GenericPayload)res;
                if (this.isPostAck()) {
                    return Uni.createFrom().item((Object)genericPayload.toMessage(message));
                }
                return Uni.createFrom().item((Object)Message.of((Object)genericPayload.getPayload(), (Metadata)Messages.merge((Metadata)message.getMetadata(), (Metadata)genericPayload.getMetadata())));
            }
            if (this.isPostAck()) {
                return Uni.createFrom().item((Object)message.withPayload(res));
            }
            return Uni.createFrom().item((Object)Message.of((Object)res, (Metadata)message.getMetadata()));
        }
        if (this.isPostAck()) {
            return Uni.createFrom().completionStage(message.ack().thenApply(x -> null));
        }
        return Uni.createFrom().nullItem();
    }

    private Uni<? extends Message<Object>> handlePostInvocationWithMessage(Message<?> in, Message<?> res, Throwable fail) {
        if (fail != null) {
            if (this.isPostAck()) {
                return Uni.createFrom().completionStage(in.nack(fail).thenApply(x -> null));
            }
            throw ProviderExceptions.ex.processingException(this.getMethodAsString(), fail);
        }
        if (res != null) {
            if (this.isPostAck()) {
                return Uni.createFrom().item((Object)res.withAckWithMetadata(m -> res.ack(m).thenCompose(x -> in.ack(m))).withNackWithMetadata((t, m) -> res.nack(t, m).thenCompose(x -> in.nack(t, m))));
            }
            return Uni.createFrom().item(res);
        }
        if (this.isPostAck()) {
            return Uni.createFrom().completionStage(in.ack().thenApply(x -> null));
        }
        return Uni.createFrom().nullItem();
    }

    private void processMethodReturningACompletionStageOfMessageAndConsumingIndividualItem() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(message -> this.invokeOnMessageContext((Message<?>)message, this.getArguments(message)).onItem().transformToUni(cs -> Uni.createFrom().completionStage((CompletionStage)cs)).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocationWithMessage((Message<?>)message, (Message<?>)((Message)r), (Throwable)f)).onItem().transformToMulti(this::handleSkip));
    }

    private void processMethodReturningAUniOfMessageAndConsumingIndividualItem() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(message -> this.invokeOnMessageContext((Message<?>)message, this.getArguments(message)).onItem().transformToUni(u -> (Uni)u).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocationWithMessage((Message<?>)message, (Message<?>)((Message)r), (Throwable)f)).onItem().transformToMulti(this::handleSkip));
    }

    private void processMethodReturningACompletionStageOfPayloadAndConsumingIndividualItem() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(message -> this.invokeOnMessageContext((Message<?>)message, this.getArguments(message)).onItem().transformToUni(cs -> Uni.createFrom().completionStage((CompletionStage)cs)).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocation((Message<?>)message, r, (Throwable)f)).onItem().transformToMulti(this::handleSkip));
    }

    private void processMethodReturningAUniOfPayloadAndConsumingIndividualItem() {
        this.mapper = upstream -> MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transformToMultiAndConcatenate(message -> this.invokeOnMessageContext((Message<?>)message, this.getArguments(message)).onItem().transformToUni(u -> (Uni)u).onItemOrFailure().transformToUni((r, f) -> this.handlePostInvocation((Message<?>)message, r, (Throwable)f)).onItem().transformToMulti(this::handleSkip));
    }

    private boolean isReturningAPublisherOrAReactiveStreamsPublisherOrAPublisherBuilder() {
        Class returnType = this.configuration.getReturnType();
        return ClassUtils.isAssignable(returnType, Flow.Publisher.class) || ClassUtils.isAssignable(returnType, Publisher.class) || ClassUtils.isAssignable(returnType, PublisherBuilder.class);
    }

    private boolean isReturningAProcessorOrAReactiveStreamsProcessorOrAProcessorBuilder() {
        Class returnType = this.configuration.getReturnType();
        return ClassUtils.isAssignable(returnType, Flow.Processor.class) || ClassUtils.isAssignable(returnType, Processor.class) || ClassUtils.isAssignable(returnType, ProcessorBuilder.class);
    }

    private boolean isPostAck() {
        return this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING;
    }
}

