/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import java.util.Objects;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;

public class DefaultEmitterConfiguration
implements EmitterConfiguration {
    private String name;
    private EmitterFactoryFor emitterType;
    private OnOverflow.Strategy overflowBufferStrategy;
    private long overflowBufferSize;
    private boolean broadcast;
    private int numberOfSubscriberBeforeConnecting;

    public DefaultEmitterConfiguration() {
    }

    public DefaultEmitterConfiguration(String name, EmitterFactoryFor emitterType, OnOverflow onOverflow, Broadcast broadcast) {
        this.name = name;
        this.emitterType = emitterType;
        if (onOverflow != null) {
            this.overflowBufferStrategy = onOverflow.value();
            this.overflowBufferSize = onOverflow.bufferSize();
        } else {
            this.overflowBufferStrategy = null;
            this.overflowBufferSize = -1L;
        }
        if (broadcast != null) {
            this.broadcast = Boolean.TRUE;
            this.numberOfSubscriberBeforeConnecting = broadcast.value();
        } else {
            this.numberOfSubscriberBeforeConnecting = -1;
        }
    }

    public String name() {
        return this.name;
    }

    public EmitterFactoryFor emitterType() {
        return this.emitterType;
    }

    public OnOverflow.Strategy overflowBufferStrategy() {
        return this.overflowBufferStrategy;
    }

    public long overflowBufferSize() {
        return this.overflowBufferSize;
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public int numberOfSubscriberBeforeConnecting() {
        return this.numberOfSubscriberBeforeConnecting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEmitterConfiguration that = (DefaultEmitterConfiguration)o;
        return this.overflowBufferSize == that.overflowBufferSize && this.broadcast == that.broadcast && this.numberOfSubscriberBeforeConnecting == that.numberOfSubscriberBeforeConnecting && Objects.equals(this.name, that.name) && Objects.equals(this.emitterType, that.emitterType) && this.overflowBufferStrategy == that.overflowBufferStrategy;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.emitterType, this.overflowBufferStrategy, this.overflowBufferSize, this.broadcast, this.numberOfSubscriberBeforeConnecting);
    }

    public String toString() {
        return "DefaultEmitterConfiguration{name='" + this.name + "', emitterType=" + this.emitterType + ", overflowBufferStrategy=" + this.overflowBufferStrategy + ", overflowBufferSize=" + this.overflowBufferSize + ", broadcast=" + this.broadcast + ", numberOfSubscriberBeforeConnecting=" + this.numberOfSubscriberBeforeConnecting + "}";
    }
}

