/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.DirtinessDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;

public final class PojoIndexingQueueEventProcessingPlanImpl
implements PojoIndexingQueueEventProcessingPlan {
    private final PojoWorkTypeContextProvider typeContextProvider;
    private final PojoWorkSessionContext sessionContext;
    private final PojoIndexingPlan delegate;

    public PojoIndexingQueueEventProcessingPlanImpl(PojoWorkTypeContextProvider typeContextProvider, PojoWorkSessionContext sessionContext, PojoIndexingPlan delegate) {
        this.typeContextProvider = typeContextProvider;
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    @Override
    public void append(String entityName, String serializedId, PojoIndexingQueueEventPayload payload) {
        PojoWorkTypeContext<?, ?> typeContext = this.typeContext(entityName);
        Object id = typeContext.identifierMapping().fromDocumentIdentifier(serializedId, this.sessionContext);
        DirtinessDescriptor dirtiness = payload.dirtiness;
        PojoTypeIndexingPlan typePlan = this.delegate.typeIfIncludedOrNull(typeContext.typeIdentifier());
        if (typePlan == null) {
            return;
        }
        typePlan.addOrUpdateOrDelete(id, payload.routes, dirtiness.updatedBecauseOfContained() || dirtiness.forceSelfDirty(), dirtiness.forceContainingDirty(), typeContext.pathOrdinals().toPathSelection(dirtiness.dirtyPaths()));
    }

    @Override
    public CompletableFuture<MultiEntityOperationExecutionReport> executeAndReport(OperationSubmitter operationSubmitter) {
        return this.delegate.executeAndReport(operationSubmitter);
    }

    @Override
    public <I> String toSerializedId(String entityName, I identifier) {
        IdentifierMappingImplementor<?, ?> identifierMapping = this.typeContext(entityName).identifierMapping();
        return identifierMapping.toDocumentIdentifier(identifier, this.sessionContext.mappingContext());
    }

    @Override
    public Object toIdentifier(String entityName, String serializedId) {
        PojoWorkTypeContext<?, ?> typeContext = this.typeContext(entityName);
        return typeContext.identifierMapping().fromDocumentIdentifier(serializedId, this.sessionContext);
    }

    private PojoWorkTypeContext<?, ?> typeContext(String entityName) {
        return (PojoWorkTypeContext)this.typeContextProvider.byEntityName().getOrFail((Object)entityName);
    }
}

