/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.threads.AsyncFuture;

public final class AsyncToCompletableFutureAdapter {
    public static <T> CompletableFuture<T> adapt(AsyncFuture<T> asyncFuture) {
        return AsyncToCompletableFutureAdapter.adapt(asyncFuture, t -> t, null);
    }

    public static <T, U> CompletableFuture<U> adapt(AsyncFuture<T> asyncFuture, Function<T, U> transformer, Consumer<Boolean> asyncCancelTask) {
        return new Adapter<T, U>(asyncFuture, transformer, asyncCancelTask);
    }

    private static class Adapter<T, U>
    extends CompletableFuture<U> {
        private final AsyncFuture<T> asyncFuture;
        private final Consumer<Boolean> asyncCancelConsumer;
        private final AtomicBoolean cancellable = new AtomicBoolean(false);
        private final CountDownLatch latch = new CountDownLatch(1);

        private Adapter(AsyncFuture<T> asyncFuture, final Function<T, U> transformer, Consumer<Boolean> asyncCancelConsumer) {
            this.asyncFuture = asyncFuture;
            this.asyncCancelConsumer = asyncCancelConsumer == null ? asyncFuture::asyncCancel : asyncCancelConsumer;
            asyncFuture.addListener(new AsyncFuture.Listener<T, Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleComplete(AsyncFuture<? extends T> future, Object attachment) {
                    try {
                        this.complete(transformer.apply(future.get()));
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.completeExceptionally(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleFailed(AsyncFuture<? extends T> future, Throwable cause, Object attachment) {
                    try {
                        this.completeExceptionally(cause);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                @Override
                public void handleCancelled(AsyncFuture<? extends T> future, Object attachment) {
                    try {
                        this.internalCancel();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.cancellable.compareAndSet(false, true)) {
                this.awaitLatch();
                return super.cancel(mayInterruptIfRunning);
            }
            try {
                boolean afCancelled;
                this.asyncCancelConsumer.accept(mayInterruptIfRunning);
                boolean bl = afCancelled = this.asyncFuture.awaitUninterruptibly() == AsyncFuture.Status.CANCELLED;
                if (afCancelled) {
                    ProtocolLogger.ROOT_LOGGER.tracef("%s: AsyncFuture is cancelled; proceeding to cancel ourself", (Object)this.getClass().getEnclosingClass().getSimpleName(), (Object)this.getClass().getSimpleName());
                } else {
                    ProtocolLogger.ROOT_LOGGER.tracef("%s.%s: Awaiting AsyncFuture.Listener before proceeding to cancel ourself", (Object)this.getClass().getEnclosingClass().getSimpleName(), (Object)this.getClass().getSimpleName());
                    this.awaitLatch();
                }
                boolean bl2 = super.cancel(mayInterruptIfRunning);
                return bl2;
            }
            finally {
                this.latch.countDown();
            }
        }

        private void internalCancel() {
            super.cancel(false);
        }

        private void awaitLatch() {
            try {
                this.latch.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

