/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.accesscontrol;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementSet;
import org.jboss.as.cli.accesscontrol.AllRequiredSet;
import org.jboss.as.cli.accesscontrol.AnyRequiredSet;
import org.jboss.as.cli.accesscontrol.BaseOperationAccessRequirement;
import org.jboss.as.cli.accesscontrol.ControllerModeAccess;
import org.jboss.as.cli.accesscontrol.HostServerOperationAccess;
import org.jboss.as.cli.accesscontrol.MainOperationAccessRequirement;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.wildfly.common.Assert;

public interface AccessRequirementBuilder {
    public RequirementSetBuilder all();

    public RequirementSetBuilder any();

    public AccessRequirementBuilder domain();

    public AccessRequirementBuilder standalone();

    public AccessRequirementBuilder parent();

    public AccessRequirement build();

    public static class Factory {
        public static AccessRequirementBuilder create(final CommandContext ctx) {
            return new AccessRequirementBuilder(){
                AccessRequirementBuilder builder;

                @Override
                public RequirementSetBuilder all() {
                    if (this.builder != null) {
                        throw new IllegalStateException("The builder has been initialized: " + this.builder);
                    }
                    this.builder = new AllRequiredBuilder(this, ctx);
                    return (RequirementSetBuilder)this.builder;
                }

                @Override
                public RequirementSetBuilder any() {
                    if (this.builder != null) {
                        throw new IllegalStateException("The builder has been initialized: " + this.builder);
                    }
                    this.builder = new AnyRequiredBuilder(this, ctx);
                    return (RequirementSetBuilder)this.builder;
                }

                @Override
                public RequirementSetBuilder domain() {
                    if (this.builder != null) {
                        throw new IllegalStateException("The builder has been initialized: " + this.builder);
                    }
                    this.builder = new DomainModeRequirementBuilder(this, ctx);
                    return (RequirementSetBuilder)this.builder;
                }

                @Override
                public RequirementSetBuilder standalone() {
                    if (this.builder != null) {
                        throw new IllegalStateException("The builder has been initialized: " + this.builder);
                    }
                    this.builder = new StandaloneModeRequirementBuilder(this, ctx);
                    return (RequirementSetBuilder)this.builder;
                }

                @Override
                public AccessRequirementBuilder parent() {
                    throw new IllegalStateException();
                }

                @Override
                public AccessRequirement build() {
                    return this.builder == null ? AccessRequirement.NONE : this.builder.build();
                }
            };
        }

        private static abstract class ControllerModeRequirementBuilder
        implements AccessRequirementBuilder {
            protected final AccessRequirementBuilder parent;
            protected final ControllerModeAccess modeReq;
            protected final CommandContext ctx;
            protected BaseRequirementSetBuilder nestedSet;

            ControllerModeRequirementBuilder(AccessRequirementBuilder parent, CommandContext ctx) {
                this.parent = parent;
                this.ctx = ctx;
                this.modeReq = this.createModeAccess();
                ctx.addEventListener(this.modeReq);
            }

            protected abstract ControllerModeAccess createModeAccess();

            @Override
            public RequirementSetBuilder all() {
                if (this.nestedSet != null) {
                    throw new IllegalStateException("The nested set has been initialized.");
                }
                this.nestedSet = new AllRequiredBuilder(this, this.ctx);
                this.modeReq.setRequirement(this.nestedSet.set);
                return this.nestedSet;
            }

            @Override
            public RequirementSetBuilder any() {
                if (this.nestedSet != null) {
                    throw new IllegalStateException("The nested set has been initialized.");
                }
                this.nestedSet = new AnyRequiredBuilder(this, this.ctx);
                this.modeReq.setRequirement(this.nestedSet.set);
                return this.nestedSet;
            }

            @Override
            public RequirementSetBuilder domain() {
                throw new IllegalStateException();
            }

            @Override
            public RequirementSetBuilder standalone() {
                throw new IllegalStateException();
            }

            @Override
            public AccessRequirementBuilder parent() {
                return this.parent;
            }

            @Override
            public AccessRequirement build() {
                return this.modeReq;
            }
        }

        private static class StandaloneModeRequirementBuilder
        extends ControllerModeRequirementBuilder {
            StandaloneModeRequirementBuilder(AccessRequirementBuilder parent, CommandContext ctx) {
                super(parent, ctx);
            }

            @Override
            protected ControllerModeAccess createModeAccess() {
                return new ControllerModeAccess(ControllerModeAccess.Mode.STANDALONE);
            }
        }

        private static class DomainModeRequirementBuilder
        extends ControllerModeRequirementBuilder {
            DomainModeRequirementBuilder(AccessRequirementBuilder parent, CommandContext ctx) {
                super(parent, ctx);
            }

            @Override
            protected ControllerModeAccess createModeAccess() {
                return new ControllerModeAccess(ControllerModeAccess.Mode.DOMAIN);
            }
        }

        private static abstract class BaseRequirementSetBuilder
        implements RequirementSetBuilder {
            protected final AccessRequirementBuilder parent;
            protected final AccessRequirementSet set;
            protected final CommandContext ctx;

            BaseRequirementSetBuilder(AccessRequirementBuilder parent, CommandContext ctx) {
                this.parent = parent;
                this.set = this.createTarget();
                this.ctx = ctx;
                ctx.addEventListener(this.set);
            }

            protected abstract AccessRequirementSet createTarget();

            @Override
            public RequirementSetBuilder all() {
                AllRequiredBuilder nested = new AllRequiredBuilder(this, this.ctx);
                this.set.add(nested.set);
                return nested;
            }

            @Override
            public RequirementSetBuilder any() {
                AnyRequiredBuilder nested = new AnyRequiredBuilder(this, this.ctx);
                this.set.add(nested.set);
                return nested;
            }

            @Override
            public AccessRequirementBuilder domain() {
                DomainModeRequirementBuilder nested = new DomainModeRequirementBuilder(this, this.ctx);
                this.set.add(nested.modeReq);
                return nested;
            }

            @Override
            public AccessRequirementBuilder standalone() {
                StandaloneModeRequirementBuilder nested = new StandaloneModeRequirementBuilder(this, this.ctx);
                this.set.add(nested.modeReq);
                return nested;
            }

            @Override
            public RequirementSetBuilder operation(String operation) {
                return this.add(new MainOperationAccessRequirement(operation));
            }

            @Override
            public RequirementSetBuilder operation(OperationRequestAddress address, String operation) {
                return this.add(new MainOperationAccessRequirement(address, operation));
            }

            @Override
            public RequirementSetBuilder serverGroupOperation(String operation) {
                return this.add(new PerNodeOperationAccess("server-group", operation));
            }

            @Override
            public RequirementSetBuilder serverGroupOperation(OperationRequestAddress address, String operation) {
                return this.add(new PerNodeOperationAccess("server-group", address, operation));
            }

            @Override
            public RequirementSetBuilder profileOperation(OperationRequestAddress address, String operation) {
                return this.add(new PerNodeOperationAccess("profile", address, operation));
            }

            @Override
            public RequirementSetBuilder operation(String address, String operation) {
                return this.add(new MainOperationAccessRequirement(address, operation));
            }

            @Override
            public RequirementSetBuilder serverGroupOperation(String address, String operation) {
                return this.add(new PerNodeOperationAccess("server-group", address, operation));
            }

            @Override
            public RequirementSetBuilder profileOperation(String address, String operation) {
                return this.add(new PerNodeOperationAccess("profile", address, operation));
            }

            @Override
            public RequirementSetBuilder hostServerOperation(String address, String operation) {
                return this.add(new HostServerOperationAccess(address, operation));
            }

            @Override
            public RequirementSetBuilder requirement(AccessRequirement requirement) {
                Assert.checkNotNullParam("requirement", requirement);
                this.set.add(requirement);
                return this;
            }

            @Override
            public AccessRequirementBuilder parent() {
                return this.parent;
            }

            protected RequirementSetBuilder add(BaseOperationAccessRequirement op) {
                this.set.add(op);
                this.ctx.addEventListener(op);
                return this;
            }

            @Override
            public AccessRequirement build() {
                return this.set;
            }
        }

        private static class AnyRequiredBuilder
        extends BaseRequirementSetBuilder {
            AnyRequiredBuilder(AccessRequirementBuilder parent, CommandContext ctx) {
                super(parent, ctx);
            }

            @Override
            protected AccessRequirementSet createTarget() {
                return new AnyRequiredSet();
            }
        }

        private static class AllRequiredBuilder
        extends BaseRequirementSetBuilder {
            AllRequiredBuilder(AccessRequirementBuilder parent, CommandContext ctx) {
                super(parent, ctx);
            }

            @Override
            protected AccessRequirementSet createTarget() {
                return new AllRequiredSet();
            }
        }
    }

    public static interface RequirementSetBuilder
    extends AccessRequirementBuilder {
        public RequirementSetBuilder operation(String var1);

        public RequirementSetBuilder operation(String var1, String var2);

        public RequirementSetBuilder serverGroupOperation(String var1);

        public RequirementSetBuilder serverGroupOperation(String var1, String var2);

        public RequirementSetBuilder profileOperation(String var1, String var2);

        public RequirementSetBuilder operation(OperationRequestAddress var1, String var2);

        public RequirementSetBuilder serverGroupOperation(OperationRequestAddress var1, String var2);

        public RequirementSetBuilder profileOperation(OperationRequestAddress var1, String var2);

        public RequirementSetBuilder hostServerOperation(String var1, String var2);

        public RequirementSetBuilder requirement(AccessRequirement var1);
    }
}

