/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.activator.NullCommandActivator;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CompleteStatus;
import org.aesh.command.impl.populator.AeshCommandPopulator;
import org.aesh.command.impl.result.NullResultHandler;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.util.Parser;
import org.aesh.selector.SelectorType;
import org.aesh.terminal.utils.Config;

public class ProcessedCommand<C extends Command<CI>, CI extends CommandInvocation> {
    private final String name;
    private final String description;
    private final CommandValidator<C, CI> validator;
    private final ResultHandler resultHandler;
    private final CommandPopulator<Object, CI> populator;
    private CommandActivator activator;
    private List<ProcessedOption> options;
    private ProcessedOption arguments;
    private ProcessedOption argument;
    private final C command;
    private final List<String> aliases;
    private List<CommandLineParserException> parserExceptions;
    private CompleteStatus completeStatus;

    public ProcessedCommand(String name, List<String> aliases, C command, String description, CommandValidator<C, CI> validator, ResultHandler resultHandler, ProcessedOption arguments, List<ProcessedOption> options, ProcessedOption argument, CommandPopulator<Object, CI> populator, CommandActivator activator) throws OptionParserException {
        this.name = name;
        this.description = description;
        this.aliases = aliases == null ? Collections.emptyList() : aliases;
        this.validator = validator;
        this.resultHandler = resultHandler != null ? resultHandler : new NullResultHandler();
        this.arguments = arguments;
        this.argument = argument;
        if (argument != null && arguments != null) {
            throw new OptionParserException("Argument and Arguments cannot be defined in the same Command");
        }
        this.options = new ArrayList<ProcessedOption>();
        this.command = command;
        this.activator = activator == null ? new NullCommandActivator() : activator;
        this.populator = populator == null ? new AeshCommandPopulator(this.command) : populator;
        this.setOptions(options);
        this.parserExceptions = new ArrayList<CommandLineParserException>();
    }

    public List<ProcessedOption> getOptions() {
        return this.options;
    }

    public CommandActivator getActivator() {
        return this.activator;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void addOption(ProcessedOption opt) throws OptionParserException {
        this.options.add(new ProcessedOption(this.verifyThatNamesAreUnique(opt.shortName(), opt.name()), opt.name(), opt.description(), opt.getArgument(), opt.isRequired(), opt.getValueSeparator(), opt.askIfNotSet(), opt.selectorType(), opt.getDefaultValues(), opt.type(), opt.getFieldName(), opt.getOptionType(), opt.converter(), opt.completer(), opt.validator(), opt.activator(), opt.getRenderer(), opt.parser(), opt.doOverrideRequired()));
        this.options.get(this.options.size() - 1).setParent(this);
    }

    private void setOptions(List<ProcessedOption> options) throws OptionParserException {
        for (ProcessedOption opt : options) {
            this.options.add(new ProcessedOption(this.verifyThatNamesAreUnique(opt.shortName(), opt.name()), opt.name(), opt.description(), opt.getArgument(), opt.isRequired(), opt.getValueSeparator(), opt.askIfNotSet(), opt.selectorType(), opt.getDefaultValues(), opt.type(), opt.getFieldName(), opt.getOptionType(), opt.converter(), opt.completer(), opt.validator(), opt.activator(), opt.getRenderer(), opt.parser(), opt.doOverrideRequired()));
            this.options.get(this.options.size() - 1).setParent(this);
        }
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public CommandValidator<C, CI> validator() {
        return this.validator;
    }

    public ResultHandler resultHandler() {
        return this.resultHandler;
    }

    public boolean hasArguments() {
        return this.arguments != null && this.arguments.hasMultipleValues();
    }

    public ProcessedOption getArguments() {
        return this.arguments;
    }

    public void setArguments(ProcessedOption arguments) {
        this.arguments = arguments;
        this.arguments.setParent(this);
    }

    public CommandPopulator<Object, CI> getCommandPopulator() {
        return this.populator;
    }

    public C getCommand() {
        return this.command;
    }

    private char verifyThatNamesAreUnique(String name, String longName) throws OptionParserException {
        if (name != null) {
            return this.verifyThatNamesAreUnique(name.charAt(0), longName);
        }
        return this.verifyThatNamesAreUnique('\u0000', longName);
    }

    private char verifyThatNamesAreUnique(char name, String longName) throws OptionParserException {
        if (longName != null && longName.length() > 0 && this.findLongOption(longName) != null) {
            throw new OptionParserException("Option --" + longName + " is already added to Param: " + this.toString());
        }
        if (name != '\u0000' && this.findOption(String.valueOf(name)) != null) {
            throw new OptionParserException("Option -" + name + " is already added to Param: " + this.toString());
        }
        if (name == '\u0000' && (longName == null || longName.length() == 0)) {
            throw new OptionParserException("Neither option name and option long name can be both null");
        }
        return name;
    }

    private char findPossibleName(String longName) throws OptionParserException {
        for (int i = 0; i < longName.length(); ++i) {
            if (this.findOption(String.valueOf(longName.charAt(i))) != null) continue;
            return longName.charAt(i);
        }
        throw new OptionParserException("All option names are taken, please specify a unique name");
    }

    public ProcessedOption findOption(String name) {
        for (ProcessedOption option : this.getOptions()) {
            if (option.shortName() == null || !option.shortName().equals(name) || !option.activator().isActivated(new ParsedCommand(this))) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption findOptionNoActivatorCheck(String name) {
        for (ProcessedOption option : this.getOptions()) {
            if (option.shortName() == null || !option.shortName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption searchAllOptions(String input) {
        if (input.startsWith("--")) {
            ProcessedOption currentOption = this.findLongOptionNoActivatorCheck(input.substring(2));
            if (currentOption == null && input.contains("=")) {
                currentOption = this.startWithLongOptionNoActivatorCheck(input.substring(2));
            }
            if (currentOption != null) {
                currentOption.setLongNameUsed(true);
            } else if (Parser.containsNonEscapedSpace(input)) {
                return this.searchAllOptions(Parser.switchSpacesToEscapedSpacesInWord(input));
            }
            return currentOption;
        }
        if (input.startsWith("-")) {
            ProcessedOption currentOption = this.findOption(input.substring(1));
            if (currentOption == null) {
                currentOption = this.startWithOption(input.substring(1));
            }
            if (currentOption != null) {
                currentOption.setLongNameUsed(false);
            }
            return currentOption;
        }
        return null;
    }

    public ProcessedOption findLongOption(String name) {
        for (ProcessedOption option : this.getOptions()) {
            if (option.name() == null || !option.name().equals(name) || !option.activator().isActivated(new ParsedCommand(this))) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption findLongOptionNoActivatorCheck(String name) {
        for (ProcessedOption option : this.getOptions()) {
            if (option.name() == null || !option.name().equals(name)) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption startWithOption(String name) {
        for (ProcessedOption option : this.getOptions()) {
            if (option.shortName() == null || !name.startsWith(option.shortName()) || !option.activator().isActivated(new ParsedCommand(this))) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption startWithLongOption(String name) {
        for (ProcessedOption option : this.getOptions()) {
            if (!name.startsWith(option.name()) || !option.activator().isActivated(new ParsedCommand(this))) continue;
            return option;
        }
        return null;
    }

    public ProcessedOption startWithLongOptionNoActivatorCheck(String name) {
        ProcessedOption longestMatch = null;
        for (ProcessedOption option : this.getOptions()) {
            if (!name.startsWith(option.name())) continue;
            if (longestMatch == null) {
                longestMatch = option;
                continue;
            }
            if (option.name().length() <= longestMatch.name().length()) continue;
            longestMatch = option;
        }
        return longestMatch;
    }

    public void clear() {
        this.clearOptions();
        if (this.arguments != null) {
            this.arguments.clear();
        }
        if (this.argument != null) {
            this.argument.clear();
        }
        this.parserExceptions.clear();
        this.completeStatus = null;
    }

    protected void clearOptions() {
        for (ProcessedOption processedOption : this.getOptions()) {
            processedOption.clear();
        }
    }

    public List<TerminalString> getOptionLongNamesWithDash() {
        List<ProcessedOption> opts = this.getOptions();
        ArrayList<TerminalString> names = new ArrayList<TerminalString>(opts.size());
        for (ProcessedOption o : opts) {
            if (o.getValues().size() != 0 || !o.activator().isActivated(new ParsedCommand(this))) continue;
            names.add(o.getRenderedNameWithDashes());
        }
        return names;
    }

    public List<TerminalString> findPossibleLongNamesWithDash(String name) {
        List<ProcessedOption> opts = this.getOptions();
        ArrayList<TerminalString> names = new ArrayList<TerminalString>(opts.size());
        for (ProcessedOption o : opts) {
            if ((o.shortName() == null || !o.shortName().equals(name) || o.isLongNameUsed() || o.getValues().size() != 0) && (!o.name().startsWith(name) || o.getValues().size() != 0) || !o.activator().isActivated(new ParsedCommand(this))) continue;
            names.add(o.getRenderedNameWithDashes());
        }
        return names;
    }

    public List<String> findPossibleLongNames(String name) {
        if (name.startsWith("--")) {
            name = name.substring(2);
        }
        List<ProcessedOption> opts = this.getOptions();
        ArrayList<String> names = new ArrayList<String>(opts.size());
        for (ProcessedOption o : opts) {
            if ((o.shortName() == null || !o.shortName().equals(name) || o.isLongNameUsed() || o.getValues().size() != 0) && (!o.name().startsWith(name) || o.getValues().size() != 0) || !o.activator().isActivated(new ParsedCommand(this))) continue;
            names.add(o.name());
        }
        return names;
    }

    public boolean hasAskIfNotSet() {
        for (ProcessedOption opt : this.getOptions()) {
            if (!opt.askIfNotSet() || !opt.hasValue() || !opt.getValues().isEmpty() || opt.hasDefaultValue()) continue;
            return true;
        }
        return false;
    }

    public List<ProcessedOption> getAllAskIfNotSet() {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        for (ProcessedOption opt : this.getOptions()) {
            if (!opt.askIfNotSet() || !opt.hasValue() || !opt.getValues().isEmpty() || opt.hasDefaultValue()) continue;
            options.add(opt);
        }
        if (this.argument != null && this.argument.askIfNotSet() && this.argument.hasValue() && this.argument.getValues().isEmpty() && !this.argument.hasDefaultValue()) {
            options.add(this.argument);
        }
        if (this.arguments != null && this.arguments.askIfNotSet() && this.arguments.hasValue() && this.arguments.getValues().isEmpty() && !this.arguments.hasDefaultValue()) {
            options.add(this.arguments);
        }
        return options;
    }

    public String printHelp(String commandName) {
        int maxLength = 0;
        int width = 80;
        List<ProcessedOption> opts = this.getOptions();
        for (ProcessedOption o : opts) {
            if (o.getFormattedLength() <= maxLength) continue;
            maxLength = o.getFormattedLength();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: ");
        if (commandName == null || commandName.length() == 0) {
            sb.append(this.name());
        } else {
            sb.append(commandName);
        }
        if (opts.size() > 0) {
            sb.append(" [<options>]");
        }
        if (this.argument != null) {
            if (this.argument.isTypeAssignableByResourcesOrFile()) {
                sb.append(" <file>");
            } else {
                sb.append(" <").append(this.argument.getFieldName()).append(">");
            }
        }
        if (this.arguments != null) {
            if (this.arguments.isTypeAssignableByResourcesOrFile()) {
                sb.append(" [<files>]");
            } else {
                sb.append(" [<").append(this.arguments.getFieldName()).append(">]");
            }
        }
        sb.append(Config.getLineSeparator());
        sb.append(this.description()).append(Config.getLineSeparator());
        if (opts.size() > 0) {
            sb.append(Config.getLineSeparator()).append("Options:").append(Config.getLineSeparator());
        }
        for (ProcessedOption o : opts) {
            sb.append(o.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        if (this.arguments != null) {
            sb.append(Config.getLineSeparator()).append("Arguments:").append(Config.getLineSeparator());
            sb.append(this.arguments.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        if (this.argument != null) {
            sb.append(Config.getLineSeparator()).append("Argument:").append(Config.getLineSeparator());
            sb.append(this.argument.getFormattedOption(2, maxLength + 4, width)).append(Config.getLineSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return "ProcessedCommand{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", options=" + this.getOptions() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProcessedCommand)) {
            return false;
        }
        ProcessedCommand that = (ProcessedCommand)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public boolean hasLongOption(String optionName) {
        for (ProcessedOption o : this.getOptions()) {
            if (!o.name().equals(optionName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOptions() {
        List<ProcessedOption> opts = this.getOptions();
        return opts != null && opts.size() > 0;
    }

    public boolean hasUniqueLongOption(String optionName) {
        if (this.hasLongOption(optionName)) {
            for (ProcessedOption o : this.getOptions()) {
                if (!o.name().startsWith(optionName) || o.name().equals(optionName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateInvocationProviders(InvocationProviders invocationProviders) {
        this.updateOptionsInvocationProviders(invocationProviders);
        if (this.argument != null) {
            this.argument.updateInvocationProviders(invocationProviders);
        }
        if (this.arguments != null) {
            this.arguments.updateInvocationProviders(invocationProviders);
        }
        this.activator = invocationProviders.getCommandActivatorProvider().enhanceCommandActivator(this.activator);
    }

    protected void updateOptionsInvocationProviders(InvocationProviders invocationProviders) {
        for (ProcessedOption option : this.getOptions()) {
            option.updateInvocationProviders(invocationProviders);
        }
    }

    public void addParserException(CommandLineParserException exception) {
        this.parserExceptions.add(exception);
    }

    public List<CommandLineParserException> parserExceptions() {
        return this.parserExceptions;
    }

    public boolean hasOptionsWithInjectedValues() {
        for (ProcessedOption option : this.options) {
            if (option.getValue() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasOptionWithOverrideRequired() {
        for (ProcessedOption option : this.options) {
            if (option.getValue() == null || !option.doOverrideRequired()) continue;
            return true;
        }
        return false;
    }

    public CompleteStatus completeStatus() {
        return this.completeStatus;
    }

    public void setCompleteStatus(CompleteStatus completeStatus) {
        this.completeStatus = completeStatus;
    }

    public void setArgument(ProcessedOption arg) {
        this.argument = arg;
        this.argument.setParent(this);
    }

    public ProcessedOption getArgument() {
        return this.argument;
    }

    public boolean hasArgument() {
        return this.argument != null;
    }

    public boolean hasArgumentWithNoValue() {
        return this.argument != null && this.argument.getValue() == null;
    }

    public boolean hasSelector() {
        for (ProcessedOption opt : this.getOptions()) {
            if (opt.selectorType() == SelectorType.NO_OP || !opt.hasValue()) continue;
            return true;
        }
        return false;
    }

    public List<ProcessedOption> getAllSelectors() {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        for (ProcessedOption opt : this.getOptions()) {
            if (opt.selectorType() == SelectorType.NO_OP || !opt.hasValue()) continue;
            options.add(opt);
        }
        if (this.argument != null && this.argument.selectorType() != SelectorType.NO_OP && (this.argument.hasValue() || this.argument.getOptionType().equals((Object)OptionType.BOOLEAN))) {
            options.add(this.argument);
        }
        if (this.arguments != null && this.arguments.selectorType() != SelectorType.NO_OP && this.arguments.hasValue()) {
            options.add(this.arguments);
        }
        return options;
    }
}

