/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.function.BooleanSupplier;
import org.HdrHistogram.SingleWriterRecorder;
import org.apache.activemq.artemis.cli.commands.messages.perf.AsyncJms2ProducerFacade;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.SkeletalProducerLoadGenerator;

public final class ProducerTargetRateLoadGenerator
extends SkeletalProducerLoadGenerator {
    private final double usPeriod;
    private long startLoadMicros;
    private long fireCount;
    private long fireTimeMicros = 0L;
    private boolean started;

    public ProducerTargetRateLoadGenerator(AsyncJms2ProducerFacade producer, OrderedEventExecutor executor, MicrosTimeProvider timeProvider, BooleanSupplier keepOnSending, long nsPeriod, String group, byte[] msgContent, SingleWriterRecorder sendCompletedLatencies, SingleWriterRecorder waitLatencies) {
        super(producer, executor, timeProvider, keepOnSending, group, msgContent, sendCompletedLatencies, waitLatencies);
        this.usPeriod = (double)nsPeriod / 1000.0;
        this.started = false;
    }

    @Override
    public void run() {
        if (this.closed || this.stopLoad) {
            return;
        }
        long now = this.timeProvider.now();
        if (!this.started) {
            this.started = true;
            this.startLoadMicros = now;
            this.fireTimeMicros = now;
        }
        if (!this.trySend(this.fireTimeMicros, now)) {
            return;
        }
        if (!this.keepOnSending.getAsBoolean()) {
            this.producer.requestClose();
            this.stopLoad = true;
            return;
        }
        ++this.fireCount;
        this.fireTimeMicros = this.startLoadMicros + (long)((double)this.fireCount * this.usPeriod);
        long delay = this.fireTimeMicros - this.timeProvider.now();
        long usToNextFireTime = Math.max(0L, delay);
        this.asyncContinue(usToNextFireTime);
    }
}

