/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters;

import io.opentelemetry.exporter.internal.http.HttpExporter;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.smallrye.opentelemetry.implementation.exporters.BufferOutputStream;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.tracing.TracingPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;

public final class VertxHttpExporter
implements SpanExporter {
    public static final String EXPORTER_NAME = "vertxhttpprotobuf";
    private final HttpExporter<TraceRequestMarshaler> delegate;

    public VertxHttpExporter(HttpExporter<TraceRequestMarshaler> delegate) {
        this.delegate = delegate;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        TraceRequestMarshaler exportRequest = TraceRequestMarshaler.create(spans);
        return this.delegate.export((Marshaler)exportRequest, spans.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public static final class VertxHttpSender
    implements HttpSender {
        private static final String TRACES_PATH = "/v1/traces";
        private final String basePath;
        private final boolean compressionEnabled;
        private final Map<String, String> headers;
        private final String contentType;
        private final HttpClient client;

        public VertxHttpSender(URI baseUri, boolean compressionEnabled, Duration timeout, Map<String, String> headersMap, String contentType, Vertx vertx) {
            this.basePath = VertxHttpSender.determineBasePath(baseUri);
            this.compressionEnabled = compressionEnabled;
            this.headers = headersMap;
            this.contentType = contentType;
            HttpClientOptions httpClientOptions = new HttpClientOptions().setReadIdleTimeout((int)timeout.getSeconds()).setDefaultHost(baseUri.getHost()).setDefaultPort(OtlpExporterUtil.getPort(baseUri)).setTracingPolicy(TracingPolicy.IGNORE);
            this.client = vertx.createHttpClient(httpClientOptions);
        }

        private static String determineBasePath(URI baseUri) {
            Object path = baseUri.getPath();
            if (((String)path).isEmpty() || ((String)path).equals("/")) {
                return "";
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return path;
        }

        public void send(final Consumer<OutputStream> marshaler, final int contentLength, final Consumer<HttpSender.Response> onResponse, final Consumer<Throwable> onError) {
            this.client.request(HttpMethod.POST, this.basePath + TRACES_PATH).onSuccess((Handler)new Handler<HttpClientRequest>(){

                public void handle(HttpClientRequest request) {
                    Buffer buffer;
                    HttpClientRequest clientRequest;
                    block10: {
                        clientRequest = request.response((Handler)new Handler<AsyncResult<HttpClientResponse>>(){

                            public void handle(AsyncResult<HttpClientResponse> callResult) {
                                if (callResult.succeeded()) {
                                    final HttpClientResponse clientResponse = (HttpClientResponse)callResult.result();
                                    clientResponse.body((Handler)new Handler<AsyncResult<Buffer>>(){

                                        public void handle(final AsyncResult<Buffer> bodyResult) {
                                            if (bodyResult.succeeded()) {
                                                onResponse.accept(new HttpSender.Response(){

                                                    public int statusCode() {
                                                        return clientResponse.statusCode();
                                                    }

                                                    public String statusMessage() {
                                                        return clientResponse.statusMessage();
                                                    }

                                                    public byte[] responseBody() {
                                                        return ((Buffer)bodyResult.result()).getBytes();
                                                    }
                                                });
                                            } else {
                                                onError.accept(bodyResult.cause());
                                            }
                                        }
                                    });
                                } else {
                                    onError.accept(callResult.cause());
                                }
                            }
                        }).putHeader("Content-Type", contentType);
                        buffer = Buffer.buffer((int)contentLength);
                        BufferOutputStream os = new BufferOutputStream(buffer);
                        if (compressionEnabled) {
                            clientRequest.putHeader("Content-Encoding", "gzip");
                            try (GZIPOutputStream gzos = new GZIPOutputStream(os);){
                                marshaler.accept(gzos);
                                break block10;
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        marshaler.accept(os);
                    }
                    if (!headers.isEmpty()) {
                        for (Map.Entry<String, String> entry : headers.entrySet()) {
                            clientRequest.putHeader(entry.getKey(), entry.getValue());
                        }
                    }
                    clientRequest.send(buffer);
                }
            }).onFailure(onError::accept);
        }

        public CompletableResultCode shutdown() {
            this.client.close();
            return CompletableResultCode.ofSuccess();
        }
    }
}

