/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.wildfly.clustering.ee.hotrod.RemoteCacheKey;
import org.wildfly.clustering.infinispan.client.near.CaffeineNearCache;
import org.wildfly.clustering.infinispan.client.near.EvictionListener;
import org.wildfly.clustering.infinispan.client.near.SimpleKeyWeigher;
import org.wildfly.clustering.web.hotrod.session.attributes.SessionAttributesKey;
import org.wildfly.clustering.web.hotrod.session.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.metadata.SessionCreationMetaDataKey;

public class SessionManagerNearCacheFactory
implements NearCacheFactory {
    private final Integer maxActiveSessions;

    public SessionManagerNearCacheFactory(Integer maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    public <K, V> NearCache<K, V> createNearCache(NearCacheConfiguration config, BiConsumer<K, MetadataValue<V>> removedConsumer) {
        EvictionListener listener = this.maxActiveSessions != null ? new EvictionListener(removedConsumer, (BiConsumer)new InvalidationListener()) : null;
        Caffeine builder = Caffeine.newBuilder();
        if (listener != null) {
            builder.executor(Runnable::run).maximumWeight(this.maxActiveSessions.longValue()).weigher((Weigher)new SimpleKeyWeigher(SessionCreationMetaDataKey.class::isInstance)).removalListener((RemovalListener)listener);
        }
        Cache cache = builder.build();
        if (listener != null) {
            listener.accept(cache);
        }
        return new CaffeineNearCache(cache);
    }

    private static class InvalidationListener
    implements BiConsumer<Cache<Object, MetadataValue<Object>>, Map.Entry<Object, Object>> {
        private InvalidationListener() {
        }

        @Override
        public void accept(Cache<Object, MetadataValue<Object>> cache, Map.Entry<Object, Object> entry) {
            Object key = entry.getKey();
            if (key instanceof SessionCreationMetaDataKey) {
                String id = (String)((SessionCreationMetaDataKey)((Object)key)).getId();
                LinkedList<RemoteCacheKey> keys = new LinkedList<RemoteCacheKey>();
                keys.add(new SessionAccessMetaDataKey(id));
                keys.add(new SessionAttributesKey(id));
                cache.invalidateAll(keys);
            }
        }
    }
}

