/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.advertise.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListener;
import org.jboss.modcluster.advertise.DatagramChannelFactory;
import org.jboss.modcluster.advertise.impl.AdvertisedServer;
import org.jboss.modcluster.config.AdvertiseConfiguration;
import org.jboss.modcluster.config.impl.ProxyConfigurationImpl;
import org.jboss.modcluster.mcmp.MCMPHandler;

public class AdvertiseListenerImpl
implements AdvertiseListener {
    public static final String DEFAULT_ENCODING = "8859_1";
    public static final String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    private DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
    private static final Logger log = Logger.getLogger(AdvertiseListenerImpl.class);
    private volatile boolean listening = false;
    private final AdvertiseConfiguration config;
    private final DatagramChannelFactory channelFactory;
    private final MessageDigest md;
    private final Map<String, AdvertisedServer> servers = new ConcurrentHashMap<String, AdvertisedServer>();
    private final MCMPHandler handler;
    private DatagramChannel channel;

    private static void digestString(MessageDigest md, String s) {
        int len = s.length();
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[i] = c < '\u007f' ? (int)c : 63;
        }
        md.update(b);
    }

    public AdvertiseListenerImpl(MCMPHandler commHandler, AdvertiseConfiguration config, DatagramChannelFactory channelFactory) throws IOException {
        this.handler = commHandler;
        this.channelFactory = channelFactory;
        this.config = config;
        this.md = this.getMessageDigest();
        this.start();
    }

    private MessageDigest getMessageDigest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public AdvertisedServer getServer(String name) {
        return this.servers.get(name);
    }

    private synchronized void initializeDatagramChannel() throws IOException {
        InetSocketAddress advertiseSocketAddress = this.config.getAdvertiseSocketAddress();
        DatagramChannel channel = this.channelFactory.createDatagramChannel(advertiseSocketAddress);
        InetAddress group = this.config.getAdvertiseSocketAddress().getAddress();
        NetworkInterface advertiseInterface = this.config.getAdvertiseInterface();
        if (advertiseInterface == null) {
            throw ModClusterLogger.LOGGER.noValidAdvertiseInterfaceConfigured();
        }
        channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, advertiseInterface);
        channel.join(group, advertiseInterface);
        this.channel = channel;
    }

    private synchronized void start() throws IOException {
        this.initializeDatagramChannel();
        AdvertiseListenerWorker worker = new AdvertiseListenerWorker(this.channel);
        Thread thread = this.config.getAdvertiseThreadFactory().newThread(worker);
        thread.start();
        this.listening = true;
        ModClusterLogger.LOGGER.startAdvertise(this.config.getAdvertiseSocketAddress());
    }

    @Override
    public void close() throws IOException {
        this.listening = false;
        this.channel.close();
    }

    private boolean verifyDigest(String digest, String server, String date, String sequence) {
        byte[] salt;
        if (this.md == null && digest == null) {
            return true;
        }
        String securityKey = this.config.getAdvertiseSecurityKey();
        if (securityKey == null) {
            salt = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        } else {
            this.md.reset();
            AdvertiseListenerImpl.digestString(this.md, securityKey);
            salt = this.md.digest();
        }
        this.md.reset();
        this.md.update(salt);
        AdvertiseListenerImpl.digestString(this.md, date);
        AdvertiseListenerImpl.digestString(this.md, sequence);
        AdvertiseListenerImpl.digestString(this.md, server);
        byte[] our = this.md.digest();
        if (our.length != digest.length() / 2) {
            return false;
        }
        int val = 0;
        for (int i = 0; i < digest.length(); ++i) {
            char ch = digest.charAt(i);
            if (i % 2 == 0) {
                val = ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48;
                continue;
            }
            if (our[i / 2] == (byte)(val = val * 16 + (ch >= 'A' ? (ch & 0xDF) - 65 + 10 : ch - 48))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    public static void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    public static void clearBuffer(Buffer buffer) {
        buffer.clear();
    }

    private class AdvertiseListenerWorker
    implements Runnable {
        private final DatagramChannel channel;

        AdvertiseListenerWorker(DatagramChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(512);
            while (true) {
                try {
                    this.channel.receive(buffer);
                    AdvertiseListenerImpl.flipBuffer(buffer);
                    String message = new String(buffer.array(), 0, buffer.remaining(), AdvertiseListenerImpl.DEFAULT_ENCODING);
                    if (!message.startsWith("HTTP/1.")) continue;
                    String[] headers = message.split("\r\n");
                    String date_str = null;
                    Date date = null;
                    int status = 0;
                    String status_desc = null;
                    String digest = null;
                    String server_name = null;
                    String sequence = null;
                    AdvertisedServer server = null;
                    boolean added = false;
                    for (int i = 0; i < headers.length; ++i) {
                        if (i == 0) {
                            String[] sline = headers[i].split(" ", 3);
                            if (sline == null || sline.length != 3 || (status = Integer.parseInt(sline[1])) < 100) break;
                            status_desc = sline[2];
                            continue;
                        }
                        String[] hdrv = headers[i].split(": ", 2);
                        if (hdrv == null || hdrv.length != 2) break;
                        if (hdrv[0].equals("Date")) {
                            date_str = hdrv[1];
                            try {
                                date = AdvertiseListenerImpl.this.dateFormat.parse(date_str);
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            continue;
                        }
                        if (hdrv[0].equals("Digest")) {
                            digest = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Sequence")) {
                            sequence = hdrv[1];
                            continue;
                        }
                        if (hdrv[0].equals("Server")) {
                            server_name = hdrv[1];
                            server = AdvertiseListenerImpl.this.servers.get(server_name);
                            if (server != null) continue;
                            server = new AdvertisedServer(server_name);
                            added = true;
                            continue;
                        }
                        if (server == null) continue;
                        server.setParameter(hdrv[0], hdrv[1]);
                    }
                    if (server != null && status > 0) {
                        if (!AdvertiseListenerImpl.this.verifyDigest(digest, server_name, date_str, sequence)) {
                            log.tracef("Advertise message digest verification failed for server %s", server_name);
                            continue;
                        }
                        log.tracef("Advertise message digest verification passed for server %s", server_name);
                        server.setDate(date);
                        server.setStatus(status, status_desc);
                        if (added) {
                            AdvertiseListenerImpl.this.servers.put(server_name, server);
                            String proxy = server.getParameter("X-Manager-Address");
                            if (proxy != null) {
                                InetSocketAddress proxyAddress = Utils.parseSocketAddress(proxy, 0);
                                AdvertiseListenerImpl.this.handler.addProxy(new ProxyConfigurationImpl(proxyAddress));
                            }
                        }
                    }
                    AdvertiseListenerImpl.this.listening = true;
                    continue;
                }
                catch (ClosedChannelException e) {
                    AdvertiseListenerImpl.this.listening = false;
                    log.trace((Object)"DatagramChannel closed");
                    return;
                }
                catch (IOException e) {
                    AdvertiseListenerImpl.this.listening = false;
                    if (!this.channel.isOpen()) {
                        return;
                    }
                    Thread.yield();
                    continue;
                }
                finally {
                    AdvertiseListenerImpl.clearBuffer(buffer);
                    continue;
                }
                break;
            }
        }
    }
}

