/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate.management;

import jakarta.persistence.EntityManagerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jipijapa.management.spi.EntityManagerFactoryAccess;
import org.jipijapa.management.spi.Operation;
import org.jipijapa.management.spi.PathAddress;
import org.jipijapa.management.spi.StatisticName;
import org.jipijapa.management.spi.Statistics;

public abstract class HibernateAbstractStatistics
implements Statistics {
    private static final String RESOURCE_BUNDLE = HibernateAbstractStatistics.class.getPackage().getName() + ".LocalDescriptions";
    private static final String RESOURCE_BUNDLE_KEY_PREFIX = "hibernate";
    protected Map<String, Operation> operations = new HashMap<String, Operation>();
    protected Set<String> childrenNames = new HashSet<String>();
    protected Set<String> writeableNames = new HashSet<String>();
    protected Map<String, Class> types = new HashMap<String, Class>();
    protected Map<Locale, ResourceBundle> rbs = new HashMap<Locale, ResourceBundle>();

    public String getResourceBundleName() {
        return RESOURCE_BUNDLE;
    }

    public String getResourceBundleKeyPrefix() {
        return RESOURCE_BUNDLE_KEY_PREFIX;
    }

    protected EntityManagerFactory getEntityManagerFactory(Object[] args) {
        PathAddress pathAddress = this.getPathAddress(args);
        for (Object arg : args) {
            if (!(arg instanceof EntityManagerFactoryAccess)) continue;
            EntityManagerFactoryAccess entityManagerFactoryAccess = (EntityManagerFactoryAccess)arg;
            return entityManagerFactoryAccess.entityManagerFactory(pathAddress.getValue("hibernate-persistence-unit"));
        }
        return null;
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.operations.keySet());
    }

    public Class getType(String name) {
        return this.types.get(name);
    }

    public boolean isOperation(String name) {
        return Operation.class.equals((Object)this.getType(name));
    }

    public boolean isAttribute(String name) {
        return !this.isOperation(name);
    }

    public boolean isWriteable(String name) {
        return this.writeableNames.contains(name);
    }

    public Object getValue(String name, EntityManagerFactoryAccess entityManagerFactoryAccess, StatisticName statisticName, PathAddress pathAddress) {
        return this.operations.get(name).invoke(new Object[]{entityManagerFactoryAccess, statisticName, pathAddress});
    }

    public void setValue(String name, Object newValue, EntityManagerFactoryAccess entityManagerFactoryAccess, StatisticName statisticName, PathAddress pathAddress) {
        this.operations.get(name).invoke(new Object[]{newValue, entityManagerFactoryAccess, statisticName, pathAddress});
    }

    protected EntityManagerFactoryAccess getEntityManagerFactoryAccess(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof EntityManagerFactoryAccess)) continue;
            EntityManagerFactoryAccess entityManagerFactoryAccess = (EntityManagerFactoryAccess)arg;
            return entityManagerFactoryAccess;
        }
        return null;
    }

    protected PathAddress getPathAddress(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof PathAddress)) continue;
            return (PathAddress)arg;
        }
        return null;
    }

    protected String getStatisticName(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof StatisticName)) continue;
            StatisticName name = (StatisticName)arg;
            return name.getName();
        }
        return null;
    }

    public Set<String> getChildrenNames() {
        return Collections.unmodifiableSet(this.childrenNames);
    }

    public Statistics getChild(String childName) {
        return null;
    }
}

