/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.spi.workmanager.notification.NotificationListener;
import org.jboss.jca.core.workmanager.WorkManagerEvent;
import org.jboss.jca.core.workmanager.WorkManagerEventQueue;
import org.jboss.logging.Logger;

public class WorkManagerCoordinator {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)WorkManagerCoordinator.class.getName());
    private static final WorkManagerCoordinator INSTANCE = new WorkManagerCoordinator();
    private ConcurrentMap<String, WorkManager> workmanagers = new ConcurrentHashMap<String, WorkManager>();
    private WorkManager defaultWorkManager = null;
    private Map<String, WorkManager> activeWorkmanagers = new HashMap<String, WorkManager>();
    private Map<String, Integer> refCountWorkmanagers = new HashMap<String, Integer>();

    private WorkManagerCoordinator() {
    }

    public static WorkManagerCoordinator getInstance() {
        return INSTANCE;
    }

    public void registerWorkManager(WorkManager wm) {
        if (wm != null) {
            if (wm.getName() == null || wm.getName().trim().equals("")) {
                throw new IllegalArgumentException("The name of WorkManager is invalid: " + wm);
            }
            log.tracef("Registering WorkManager: %s", wm);
            if (!this.workmanagers.keySet().contains(wm.getName())) {
                WorkManagerEventQueue wmeq;
                List<WorkManagerEvent> events;
                this.workmanagers.put(wm.getName(), wm);
                if (wm instanceof DistributedWorkManager && (events = (wmeq = WorkManagerEventQueue.getInstance()).getEvents(wm.getName())).size() > 0) {
                    log.tracef("%s: Events=%s", wm.getName(), events);
                    for (WorkManagerEvent event : events) {
                        ArrayList copy;
                        DistributedWorkManager dwm;
                        if (event.getType() == 0) {
                            dwm = this.resolveDistributedWorkManager(event.getAddress());
                            if (dwm == null) continue;
                            copy = new ArrayList(dwm.getNotificationListeners());
                            for (NotificationListener nl : copy) {
                                nl.join(event.getAddress());
                            }
                            continue;
                        }
                        if (event.getType() == 1) {
                            dwm = (DistributedWorkManager)this.activeWorkmanagers.get(event.getAddress().getWorkManagerId());
                            if (dwm != null) {
                                copy = new ArrayList(dwm.getNotificationListeners());
                                for (NotificationListener nl : copy) {
                                    nl.leave(event.getAddress());
                                }
                            }
                            this.removeWorkManager(event.getAddress().getWorkManagerId());
                            continue;
                        }
                        if (event.getType() == 2) {
                            dwm = (DistributedWorkManager)this.activeWorkmanagers.get(event.getAddress().getWorkManagerId());
                            if (dwm == null) continue;
                            copy = new ArrayList(dwm.getNotificationListeners());
                            for (NotificationListener nl : copy) {
                                nl.updateShortRunningFree(event.getAddress(), event.getValue());
                            }
                            continue;
                        }
                        if (event.getType() != 3 || (dwm = (DistributedWorkManager)this.activeWorkmanagers.get(event.getAddress().getWorkManagerId())) == null) continue;
                        copy = new ArrayList(dwm.getNotificationListeners());
                        for (NotificationListener nl : copy) {
                            nl.updateLongRunningFree(event.getAddress(), event.getValue());
                        }
                    }
                }
            }
        }
    }

    public void unregisterWorkManager(WorkManager wm) {
        if (wm != null) {
            if (wm.getName() == null || wm.getName().trim().equals("")) {
                throw new IllegalArgumentException("The name of WorkManager is invalid: " + wm);
            }
            log.tracef("Unregistering WorkManager: %s", wm);
            if (this.workmanagers.keySet().contains(wm.getName())) {
                this.workmanagers.remove(wm.getName());
                if (wm instanceof DistributedWorkManager) {
                    WorkManagerEventQueue wmeq = WorkManagerEventQueue.getInstance();
                    List<WorkManagerEvent> events = wmeq.getEvents(wm.getName());
                    events.clear();
                }
            }
        }
    }

    public WorkManager getDefaultWorkManager() {
        return this.defaultWorkManager;
    }

    public void setDefaultWorkManager(WorkManager wm) {
        log.tracef("Default WorkManager: %s", wm);
        String currentName = null;
        if (this.defaultWorkManager != null) {
            currentName = this.defaultWorkManager.getName();
        }
        this.defaultWorkManager = wm;
        if (wm != null) {
            this.workmanagers.put(wm.getName(), wm);
        } else if (currentName != null) {
            this.workmanagers.remove(currentName);
        }
    }

    public WorkManager resolveWorkManager(Address address) {
        log.tracef("resolveWorkManager(%s)", address);
        log.tracef("  ActiveWorkManagers: %s", this.activeWorkmanagers);
        WorkManager wm = this.activeWorkmanagers.get(address.getWorkManagerId());
        if (wm != null) {
            log.tracef(" WorkManager: %s", wm);
            return wm;
        }
        try {
            WorkManager template = (WorkManager)this.workmanagers.get(address.getWorkManagerName());
            if (template != null) {
                wm = template.clone();
                wm.setId(address.getWorkManagerId());
                if (wm instanceof DistributedWorkManager) {
                    DistributedWorkManager dwm = (DistributedWorkManager)wm;
                    dwm.initialize();
                }
                this.activeWorkmanagers.put(address.getWorkManagerId(), wm);
                this.refCountWorkmanagers.put(address.getWorkManagerId(), 0);
                log.tracef("Created WorkManager: %s", wm);
                return wm;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public DistributedWorkManager resolveDistributedWorkManager(Address address) {
        log.tracef("resolveDistributedWorkManager(%s)", address);
        log.tracef("  ActiveWorkManagers: %s", this.activeWorkmanagers);
        WorkManager wm = this.activeWorkmanagers.get(address.getWorkManagerId());
        if (wm != null) {
            if (wm instanceof DistributedWorkManager) {
                log.tracef(" WorkManager: %s", wm);
                return (DistributedWorkManager)wm;
            }
            log.tracef(" WorkManager not distributable: %s", wm);
            return null;
        }
        try {
            WorkManager template = (WorkManager)this.workmanagers.get(address.getWorkManagerName());
            if (template != null) {
                wm = template.clone();
                wm.setId(address.getWorkManagerId());
                if (wm instanceof DistributedWorkManager) {
                    DistributedWorkManager dwm = (DistributedWorkManager)wm;
                    dwm.initialize();
                    this.activeWorkmanagers.put(address.getWorkManagerId(), (WorkManager)dwm);
                    this.refCountWorkmanagers.put(address.getWorkManagerId(), 0);
                    log.tracef("Created WorkManager: %s", dwm);
                    return dwm;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public synchronized WorkManager createWorkManager(String id, String name) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("The id of WorkManager is invalid: " + id);
        }
        if (this.activeWorkmanagers.keySet().contains(id)) {
            DistributedWorkManager dwm;
            log.tracef("RefCounting WorkManager: %s", id);
            Integer i = this.refCountWorkmanagers.get(id);
            this.refCountWorkmanagers.put(id, i + 1);
            WorkManager wm = this.activeWorkmanagers.get(id);
            if (wm instanceof DistributedWorkManager && (dwm = (DistributedWorkManager)wm).getTransport() != null) {
                dwm.getTransport().register(new Address(wm.getId(), wm.getName(), dwm.getTransport().getId()));
            }
            return wm;
        }
        try {
            WorkManager template = null;
            template = name != null ? (WorkManager)this.workmanagers.get(name) : this.defaultWorkManager;
            if (template == null) {
                throw new IllegalArgumentException("The WorkManager wasn't found: " + name);
            }
            WorkManager wm = template.clone();
            wm.setId(id);
            if (wm instanceof DistributedWorkManager) {
                DistributedWorkManager dwm = (DistributedWorkManager)wm;
                dwm.initialize();
                if (dwm.getTransport() != null) {
                    dwm.getTransport().register(new Address(wm.getId(), wm.getName(), dwm.getTransport().getId()));
                } else {
                    log.debugf("DistributedWorkManager '%s' doesn't have a transport associated", dwm.getName());
                }
            }
            this.activeWorkmanagers.put(id, wm);
            this.refCountWorkmanagers.put(id, 1);
            log.tracef("Created WorkManager: %s", wm);
            return wm;
        }
        catch (Throwable t) {
            throw new IllegalStateException("The WorkManager couldn't be created: " + name, t);
        }
    }

    public synchronized void removeWorkManager(String id) {
        if (id == null || id.trim().equals("")) {
            throw new IllegalArgumentException("The id of WorkManager is invalid: " + id);
        }
        Integer i = this.refCountWorkmanagers.get(id);
        if (i != null) {
            int newValue = i - 1;
            if (newValue == 0) {
                DistributedWorkManager dwm;
                log.tracef("Removed WorkManager: %s", id);
                WorkManager wm = this.activeWorkmanagers.get(id);
                if (wm instanceof DistributedWorkManager && (dwm = (DistributedWorkManager)wm).getTransport() != null) {
                    dwm.getTransport().unregister(new Address(wm.getId(), wm.getName(), dwm.getTransport().getId()));
                }
                this.activeWorkmanagers.remove(id);
                this.refCountWorkmanagers.remove(id);
            } else {
                log.tracef("DerefCount WorkManager: %s", id);
                this.refCountWorkmanagers.put(id, newValue);
            }
        }
    }
}

