/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;

public interface ResourceServiceInstaller {
    public Consumer<OperationContext> install(OperationContext var1);

    public static ResourceServiceInstaller combine(ResourceServiceInstaller ... installers) {
        return ResourceServiceInstaller.combine(List.of(installers));
    }

    public static ResourceServiceInstaller combine(final Collection<? extends ResourceServiceInstaller> installers) {
        return new ResourceServiceInstaller(){

            @Override
            public Consumer<OperationContext> install(OperationContext context) {
                final ArrayList<Consumer<OperationContext>> removers = new ArrayList<Consumer<OperationContext>>(installers.size());
                for (ResourceServiceInstaller installer : installers) {
                    removers.add(installer.install(context));
                }
                return new Consumer<OperationContext>(){

                    @Override
                    public void accept(OperationContext context) {
                        for (Consumer remover : removers) {
                            remover.accept(context);
                        }
                    }
                };
            }
        };
    }
}

