/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.Queues;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public final class MultiZipOp<O>
extends AbstractMulti<O> {
    private final List<Flow.Publisher<?>> upstreams = new LinkedList();
    private final Function<List<?>, ? extends O> combinator;
    private final int bufferSize;
    private final boolean collectFailures;

    public MultiZipOp(Iterable<? extends Flow.Publisher<?>> upstreams, Function<List<?>, ? extends O> combinator, int bufferSize, boolean collectFailures) {
        upstreams.forEach(this.upstreams::add);
        this.combinator = combinator;
        this.bufferSize = bufferSize;
        this.collectFailures = collectFailures;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> downstream) {
        if (this.upstreams.size() == 0) {
            Subscriptions.complete(downstream);
            return;
        }
        ZipCoordinator<O> coordinator = new ZipCoordinator<O>(downstream, this.combinator, this.upstreams.size(), this.bufferSize, this.collectFailures);
        downstream.onSubscribe(coordinator);
        coordinator.subscribe(this.upstreams);
    }

    private static class FixedSizeArrayList<T>
    extends ArrayList<T> {
        private final int size;

        public FixedSizeArrayList(int size) {
            super(size);
            this.size = size;
            for (int i = 0; i < size; ++i) {
                this.add(null);
            }
        }

        private void fill(int size) {
            for (int i = 0; i < size; ++i) {
                this.set(i, null);
            }
        }

        @Override
        public void clear() {
            this.fill(this.size);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static final class ZipSubscriber<R>
    implements MultiSubscriber<Object>,
    Flow.Subscription,
    ContextSupport {
        private final AtomicReference<Flow.Subscription> upstream = new AtomicReference();
        private final ZipCoordinator<R> parent;
        private final int prefetch;
        private final int limit;
        private final Context context;
        private Queue<Object> queue;
        private long produced;
        private volatile boolean done;

        ZipSubscriber(Context context, ZipCoordinator<R> parent, int prefetch) {
            this.context = context;
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.upstream.compareAndSet(null, s)) {
                this.queue = Queues.get(this.prefetch).get();
                s.request(this.prefetch);
            }
        }

        @Override
        public void onItem(Object item) {
            this.queue.offer(item);
            this.parent.drain();
        }

        @Override
        public void onFailure(Throwable t) {
            this.parent.error(this, t);
        }

        @Override
        public void onCompletion() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void cancel() {
            Subscriptions.cancel(this.upstream);
        }

        @Override
        public void request(long n) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                this.upstream.get().request(p);
            } else {
                this.produced = p;
            }
        }

        @Override
        public Context context() {
            return this.context;
        }
    }

    static final class ZipCoordinator<R>
    implements Flow.Subscription {
        private final AtomicInteger wip = new AtomicInteger();
        private final MultiSubscriber<? super R> downstream;
        private final List<ZipSubscriber<R>> subscribers;
        private final Function<List<?>, ? extends R> combinator;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicReference<Throwable> failures = new AtomicReference();
        private final boolean collectFailures;
        private volatile boolean cancelled;
        private final List<Object> current;

        ZipCoordinator(MultiSubscriber<? super R> downstream, Function<List<?>, ? extends R> combinator, int n, int prefetch, boolean collectFailures) {
            this.downstream = downstream;
            this.combinator = combinator;
            this.collectFailures = collectFailures;
            Context context = downstream instanceof ContextSupport ? ((ContextSupport)((Object)downstream)).context() : Context.empty();
            this.subscribers = new ArrayList<ZipSubscriber<R>>();
            for (int i = 0; i < n; ++i) {
                this.subscribers.add(new ZipSubscriber(context, this, prefetch));
            }
            this.current = new FixedSizeArrayList<Object>(n);
        }

        void subscribe(List<Flow.Publisher<?>> sources) {
            for (int i = 0; i < sources.size(); ++i) {
                if (this.cancelled || !this.collectFailures && this.failures.get() != null) {
                    return;
                }
                Flow.Publisher<?> publisher = sources.get(i);
                publisher.subscribe(Infrastructure.onMultiSubscription(publisher, (Flow.Subscriber)this.subscribers.get(i)));
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
            }
        }

        void error(ZipSubscriber<R> inner, Throwable e) {
            if (Subscriptions.addFailure(this.failures, e)) {
                inner.done = true;
                this.drain();
            }
        }

        void cancelAll() {
            for (ZipSubscriber<R> s : this.subscribers) {
                s.cancel();
            }
        }

        private void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            List<ZipSubscriber<R>> qs = this.subscribers;
            int n = qs.size();
            List<Object> values = this.current;
            int missed = 1;
            do {
                long emitted;
                long requests = this.requested.get();
                for (emitted = 0L; requests != emitted; ++emitted) {
                    R v;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.collectFailures && this.failures.get() != null) {
                        this.cancelAll();
                        Subscriptions.terminateAndPropagate(this.failures, this.downstream);
                        return;
                    }
                    boolean empty = false;
                    for (int j = 0; j < n; ++j) {
                        boolean sourceEmpty;
                        ZipSubscriber<R> inner = qs.get(j);
                        if (values.get(j) != null) continue;
                        boolean d = inner.done;
                        Queue<Object> q = inner.queue;
                        Object v2 = q != null ? q.poll() : null;
                        boolean bl = sourceEmpty = v2 == null;
                        if (d && sourceEmpty) {
                            this.cancelAll();
                            Subscriptions.terminateAndPropagate(this.failures, this.downstream);
                            return;
                        }
                        if (!sourceEmpty) {
                            values.set(j, v2);
                            continue;
                        }
                        empty = true;
                    }
                    if (empty) break;
                    try {
                        v = this.combinator.apply(values);
                        if (v == null) {
                            throw new NullPointerException("The zipper method returned `null`");
                        }
                    }
                    catch (Throwable ex) {
                        this.cancelAll();
                        Subscriptions.addFailure(this.failures, ex);
                        Subscriptions.terminateAndPropagate(this.failures, this.downstream);
                        return;
                    }
                    this.downstream.onItem(v);
                    values.clear();
                }
                if (requests == emitted) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.collectFailures && this.failures.get() != null) {
                        this.cancelAll();
                        Subscriptions.terminateAndPropagate(this.failures, this.downstream);
                        return;
                    }
                    for (int j = 0; j < n; ++j) {
                        boolean empty;
                        ZipSubscriber<R> inner = qs.get(j);
                        if (values.get(j) != null) continue;
                        boolean d = inner.done;
                        Queue<Object> q = inner.queue;
                        Object v = q != null ? q.poll() : null;
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            this.cancelAll();
                            Subscriptions.terminateAndPropagate(this.failures, this.downstream);
                            return;
                        }
                        if (empty) continue;
                        values.set(j, v);
                    }
                }
                if (emitted == 0L) continue;
                for (ZipSubscriber<R> inner : qs) {
                    inner.request(emitted);
                }
                if (requests == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-emitted);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }
}

