/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.resources.impl;

import org.hibernate.search.backend.lucene.cfg.spi.LuceneBackendSpiSettings;
import org.hibernate.search.backend.lucene.work.spi.LuceneWorkExecutorProvider;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;

public class BackendThreads {
    private static final ConfigurationProperty<BeanReference<? extends LuceneWorkExecutorProvider>> BACKEND_WORK_EXECUTOR_PROVIDER = ConfigurationProperty.forKey((String)"backend_work_executor_provider").asBeanReference(LuceneWorkExecutorProvider.class).withDefault(LuceneBackendSpiSettings.Defaults.BACKEND_WORK_EXECUTOR_PROVIDER).build();
    private final String prefix;
    private ThreadPoolProvider threadPoolProvider;
    private SimpleScheduledExecutor writeExecutor;

    public BackendThreads(String prefix) {
        this.prefix = prefix;
    }

    public void onStart(final ConfigurationPropertySource propertySource, BeanResolver beanResolver, final ThreadPoolProvider threadPoolProvider) {
        if (this.writeExecutor != null) {
            return;
        }
        this.threadPoolProvider = threadPoolProvider;
        try (BeanHolder provider = (BeanHolder)BACKEND_WORK_EXECUTOR_PROVIDER.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));){
            this.writeExecutor = ((LuceneWorkExecutorProvider)provider.get()).writeExecutor(new LuceneWorkExecutorProvider.Context(){

                @Override
                public ThreadPoolProvider threadPoolProvider() {
                    return threadPoolProvider;
                }

                @Override
                public ConfigurationPropertySource propertySource() {
                    return propertySource;
                }

                @Override
                public String recommendedThreadNamePrefix() {
                    return BackendThreads.this.prefix + " - Worker thread";
                }
            });
        }
    }

    public void onStop() {
        try (Closer closer = new Closer();){
            closer.push(SimpleScheduledExecutor::shutdownNow, (Object)this.writeExecutor);
        }
    }

    public ThreadProvider getThreadProvider() {
        this.checkStarted();
        return this.threadPoolProvider.threadProvider();
    }

    public SimpleScheduledExecutor getWriteExecutor() {
        this.checkStarted();
        return this.writeExecutor;
    }

    private void checkStarted() {
        if (this.writeExecutor == null) {
            throw new AssertionFailure("Attempt to retrieve the executor or related information before the backend was started.");
        }
    }
}

