/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import javax.naming.InitialContext;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public class BinderServiceUtil {
    public static void installBinderService(ServiceTarget serviceTarget, String name, Object obj) {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory(obj));
        serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).install();
    }

    public static void installBinderService(ServiceTarget serviceTarget, String name, Service<?> service, ServiceName dependency) {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory(service));
        ServiceBuilder serviceBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (dependency != null) {
            serviceBuilder.requires(dependency);
        }
        serviceBuilder.install();
    }

    public static void installAliasBinderService(ServiceTarget serviceTarget, ContextNames.BindInfo bindInfo, final String alias) {
        ContextNames.BindInfo aliasBindInfo = ContextNames.bindInfoFor((String)alias);
        BinderService aliasBinderService = new BinderService(alias);
        aliasBinderService.getManagedObjectInjector().inject((Object)new AliasManagedReferenceFactory(bindInfo.getAbsoluteJndiName()));
        ServiceBuilder sb = serviceTarget.addService(aliasBindInfo.getBinderServiceName(), (Service)aliasBinderService);
        sb.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)aliasBinderService.getNamingStoreInjector());
        sb.requires(bindInfo.getBinderServiceName());
        sb.addListener(new LifecycleListener(){
            private volatile boolean bound;

            public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                switch (event) {
                    case UP: {
                        MessagingLogger.ROOT_LOGGER.boundJndiName(alias);
                        this.bound = true;
                        break;
                    }
                    case DOWN: {
                        if (!this.bound) break;
                        MessagingLogger.ROOT_LOGGER.unboundJndiName(alias);
                        break;
                    }
                    case REMOVED: {
                        MessagingLogger.ROOT_LOGGER.debugf("Removed messaging object [%s]", alias);
                    }
                }
            }
        });
        sb.install();
    }

    private static final class AliasManagedReferenceFactory
    implements ContextListAndJndiViewManagedReferenceFactory {
        private final String name;

        public AliasManagedReferenceFactory(String name) {
            this.name = name;
        }

        public ManagedReference getReference() {
            try {
                Object value = new InitialContext().lookup(this.name);
                return new ValueManagedReference(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getInstanceClassName() {
            Object value = this.getReference().getInstance();
            return value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
        }

        public String getJndiViewInstanceValue() {
            return String.valueOf(this.getReference().getInstance());
        }
    }
}

