/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.injection;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.Bean;
import java.io.IOException;
import java.lang.reflect.Method;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedConstructorImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedMethodImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedParameterImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedCallable;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPointImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class ParameterInjectionPointMarshaller<T, X>
implements ProtoStreamMarshaller<ParameterInjectionPointImpl<T, X>> {
    private static final int PARAMETER_INDEX = 1;
    private static final int BEAN_INDEX = 2;

    public Class<? extends ParameterInjectionPointImpl<T, X>> getJavaClass() {
        return ParameterInjectionPoint.class;
    }

    public ParameterInjectionPointImpl<T, X> readFrom(ProtoStreamReader reader) throws IOException {
        BackedAnnotatedParameter parameter = null;
        BeanIdentifier beanId = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    parameter = (BackedAnnotatedParameter)reader.readObject(BackedAnnotatedParameter.class);
                    continue block4;
                }
                case 2: {
                    beanId = (BeanIdentifier)reader.readAny(BeanIdentifier.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        BackedAnnotatedCallable callable = parameter.getDeclaringCallable();
        BackedAnnotatedType type = callable.getDeclaringType();
        AnnotatedTypeIdentifier identifier = (AnnotatedTypeIdentifier)type.getIdentifier();
        BeanManagerImpl manager = Container.instance((AnnotatedTypeIdentifier)identifier).getBeanManager(identifier.getBdaId());
        ClassTransformer transformer = ClassTransformer.instance((BeanManagerImpl)manager);
        Bean bean = beanId != null ? (Bean)((ContextualStore)Container.instance((BeanManagerImpl)manager).services().get(ContextualStore.class)).getContextual(beanId) : null;
        EnhancedAnnotatedMethodImpl enhancedCallable = callable.getJavaMember() instanceof Method ? EnhancedAnnotatedMethodImpl.of((AnnotatedMethod)((AnnotatedMethod)callable), (EnhancedAnnotatedType)transformer.getEnhancedAnnotatedType((SlimAnnotatedType)type), (ClassTransformer)transformer) : EnhancedAnnotatedConstructorImpl.of((AnnotatedConstructor)((AnnotatedConstructor)callable), (EnhancedAnnotatedType)transformer.getEnhancedAnnotatedType((SlimAnnotatedType)type), (ClassTransformer)transformer);
        return (ParameterInjectionPointImpl)InjectionPointFactory.silentInstance().createParameterInjectionPoint(EnhancedAnnotatedParameterImpl.of((AnnotatedParameter)parameter, (EnhancedAnnotatedCallable)enhancedCallable, (ClassTransformer)transformer), bean, this.getJavaClass(), manager);
    }

    public void writeTo(ProtoStreamWriter writer, ParameterInjectionPointImpl<T, X> injectionPoint) throws IOException {
        Bean bean;
        BackedAnnotatedParameter parameter = (BackedAnnotatedParameter)injectionPoint.getAnnotated();
        if (parameter != null) {
            writer.writeObject(1, (Object)parameter);
        }
        if ((bean = injectionPoint.getBean()) != null) {
            BeanIdentifier beanId = ((ContextualStore)Container.instance((AnnotatedTypeIdentifier)parameter.getDeclaringCallable().getDeclaringType().getIdentifier()).services().get(ContextualStore.class)).putIfAbsent((Contextual)bean);
            writer.writeAny(2, (Object)beanId);
        }
    }
}

