/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.ws.common.deployment.DefaultDeployment;
import org.jboss.ws.common.deployment.ResourceResolverImpl;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ArchiveDeploymentImpl
extends DefaultDeployment
implements ArchiveDeployment {
    private final ArchiveDeployment parent;
    private final UnifiedVirtualFile rootFile;
    private List<UnifiedVirtualFile> metadataFiles;

    ArchiveDeploymentImpl(String simpleName, ClassLoader classLoader, UnifiedVirtualFile rootFile) {
        super(simpleName, classLoader);
        this.parent = null;
        this.rootFile = rootFile;
    }

    ArchiveDeploymentImpl(ArchiveDeployment parent, String simpleName, ClassLoader classLoader, UnifiedVirtualFile rootFile) {
        super(simpleName, classLoader);
        this.parent = parent;
        this.rootFile = rootFile;
    }

    public ArchiveDeployment getParent() {
        return this.parent;
    }

    public UnifiedVirtualFile getRootFile() {
        return this.rootFile;
    }

    public String getCanonicalName() {
        Object name = this.getSimpleName();
        if (this.getParent() != null) {
            name = this.getParent().getCanonicalName() + "/" + (String)name;
        }
        return name;
    }

    public synchronized List<UnifiedVirtualFile> getMetadataFiles() {
        if (this.metadataFiles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.metadataFiles);
    }

    public synchronized void addMetadataFile(UnifiedVirtualFile file) {
        if (this.metadataFiles == null) {
            this.metadataFiles = new ArrayList<UnifiedVirtualFile>();
        }
        this.metadataFiles.add(file);
    }

    public ResourceResolver getResourceResolver() {
        return new ResourceResolverImpl(this);
    }
}

