/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.util.Hashtable;

public class Helper
implements AuxGen {
    protected Hashtable symbolTable;
    protected SymtabEntry entry;
    protected GenFileStream stream;
    protected String helperClass;
    protected String helperType;

    @Override
    public void generate(Hashtable symbolTable, SymtabEntry entry) {
        this.symbolTable = symbolTable;
        this.entry = entry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.helperClass = this.entry.name() + "Helper";
        if (this.entry instanceof ValueBoxEntry) {
            ValueBoxEntry v = (ValueBoxEntry)this.entry;
            TypedefEntry member = ((InterfaceState)v.state().elementAt((int)0)).entry;
            SymtabEntry mType = member.type();
            this.helperType = mType instanceof PrimitiveEntry ? Util.javaName(this.entry) : Util.javaName(mType);
        } else {
            this.helperType = Util.javaName(this.entry);
        }
    }

    protected void openStream() {
        this.stream = Util.stream(this.entry, "Helper.java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.entry, (short)2);
        Util.writeProlog(this.stream, this.stream.name());
        if (this.entry.comment() != null) {
            this.entry.comment().generate("", this.stream);
        }
        this.stream.print("public final class " + this.helperClass);
        if (this.entry instanceof ValueEntry) {
            this.stream.println(" implements org.omg.CORBA.portable.ValueHelper");
        } else {
            this.stream.println();
        }
        this.stream.println('{');
    }

    protected void writeBody() {
        this.writeInstVars();
        this.writeCtors();
        this.writeInsert();
        this.writeExtract();
        this.writeType();
        this.writeID();
        this.writeRead();
        this.writeWrite();
        if (this.entry instanceof InterfaceEntry && !(this.entry instanceof ValueEntry)) {
            this.writeNarrow();
            this.writeUncheckedNarrow();
        }
        this.writeHelperInterface();
        if (this.entry instanceof ValueEntry) {
            this.writeValueHelperInterface();
        }
    }

    protected void writeHelperInterface() {
    }

    protected void writeValueHelperInterface() {
        this.writeGetID();
        this.writeGetType();
        this.writeGetInstance();
        this.writeGetClass();
        this.writeGetSafeBaseIds();
    }

    protected void writeClosing() {
        this.stream.println('}');
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeInstVars() {
        this.stream.println("  private static String  _id = \"" + Util.stripLeadingUnderscoresFromID(this.entry.repositoryID().ID()) + "\";");
        if (this.entry instanceof ValueEntry) {
            this.stream.println();
            this.stream.println("  private static " + this.helperClass + " helper = new " + this.helperClass + " ();");
            this.stream.println();
            this.stream.println("  private static String[] _truncatable_ids = {");
            this.stream.print("    _id");
            ValueEntry child = (ValueEntry)this.entry;
            while (child.isSafe()) {
                this.stream.println(",");
                ValueEntry parent = (ValueEntry)child.derivedFrom().elementAt(0);
                this.stream.print("    \"" + Util.stripLeadingUnderscoresFromID(parent.repositoryID().ID()) + "\"");
                child = parent;
            }
            this.stream.println("   };");
        }
        this.stream.println();
    }

    protected void writeCtors() {
        this.stream.println("  public " + this.helperClass + "()");
        this.stream.println("  {");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeInsert() {
        this.stream.println("  public static void insert (org.omg.CORBA.Any a, " + this.helperType + " that)");
        this.stream.println("  {");
        this.stream.println("    org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();");
        this.stream.println("    a.type (type ());");
        this.stream.println("    write (out, that);");
        this.stream.println("    a.read_value (out.create_input_stream (), type ());");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeExtract() {
        this.stream.println("  public static " + this.helperType + " extract (org.omg.CORBA.Any a)");
        this.stream.println("  {");
        this.stream.println("    return read (a.create_input_stream ());");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeType() {
        boolean canRecurse = this.entry instanceof ValueEntry || this.entry instanceof ValueBoxEntry || this.entry instanceof StructEntry;
        this.stream.println("  private static org.omg.CORBA.TypeCode __typeCode = null;");
        if (canRecurse) {
            this.stream.println("  private static boolean __active = false;");
        }
        this.stream.println("  synchronized public static org.omg.CORBA.TypeCode type ()");
        this.stream.println("  {");
        this.stream.println("    if (__typeCode == null)");
        this.stream.println("    {");
        if (canRecurse) {
            this.stream.println("      synchronized (org.omg.CORBA.TypeCode.class)");
            this.stream.println("      {");
            this.stream.println("        if (__typeCode == null)");
            this.stream.println("        {");
            this.stream.println("          if (__active)");
            this.stream.println("          {");
            this.stream.println("            return org.omg.CORBA.ORB.init().create_recursive_tc ( _id );");
            this.stream.println("          }");
            this.stream.println("          __active = true;");
            ((JavaGenerator)((Object)this.entry.generator())).helperType(0, "          ", new TCOffsets(), "__typeCode", this.entry, this.stream);
        } else {
            ((JavaGenerator)((Object)this.entry.generator())).helperType(0, "      ", new TCOffsets(), "__typeCode", this.entry, this.stream);
        }
        if (canRecurse) {
            this.stream.println("          __active = false;");
            this.stream.println("        }");
            this.stream.println("      }");
        }
        this.stream.println("    }");
        this.stream.println("    return __typeCode;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeID() {
        this.stream.println("  public static String id ()");
        this.stream.println("  {");
        this.stream.println("    return _id;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeRead() {
        boolean isLocalInterface = false;
        if (this.entry instanceof InterfaceEntry) {
            InterfaceEntry ie = (InterfaceEntry)this.entry;
            isLocalInterface = ie.isLocal() | ie.isLocalServant();
        }
        this.stream.println("  public static " + this.helperType + " read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        if (!isLocalInterface) {
            ((JavaGenerator)((Object)this.entry.generator())).helperRead(this.helperType, this.entry, this.stream);
        } else {
            this.stream.println("      throw new org.omg.CORBA.MARSHAL ();");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeWrite() {
        boolean isLocalInterface = false;
        if (this.entry instanceof InterfaceEntry) {
            InterfaceEntry ie = (InterfaceEntry)this.entry;
            isLocalInterface = ie.isLocal() | ie.isLocalServant();
        }
        this.stream.println("  public static void write (org.omg.CORBA.portable.OutputStream ostream, " + this.helperType + " value)");
        this.stream.println("  {");
        if (!isLocalInterface) {
            ((JavaGenerator)((Object)this.entry.generator())).helperWrite(this.entry, this.stream);
        } else {
            this.stream.println("      throw new org.omg.CORBA.MARSHAL ();");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeNarrow() {
        this.writeRemoteNarrow();
        this.stream.println();
    }

    protected void writeRemoteNarrow() {
        InterfaceEntry ie = (InterfaceEntry)this.entry;
        if (ie.isLocal()) {
            this.writeRemoteNarrowForLocal(false);
            return;
        }
        if (ie.isAbstract()) {
            this.writeRemoteNarrowForAbstract(false);
            return;
        }
        for (int i = 0; i < ie.derivedFrom().size(); ++i) {
            SymtabEntry parent = (SymtabEntry)ie.derivedFrom().elementAt(i);
            if (!((InterfaceEntry)parent).isAbstract()) continue;
            this.writeRemoteNarrowForAbstract(true);
            break;
        }
        this.stream.println("  public static " + this.helperType + " narrow (org.omg.CORBA.Object obj)");
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        this.stream.println("    else if (obj instanceof " + this.helperType + ")");
        this.stream.println("      return (" + this.helperType + ")obj;");
        this.stream.println("    else if (!obj._is_a (id ()))");
        this.stream.println("      throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("    else");
        this.stream.println("    {");
        this.stream.println("      org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate ();");
        String stubNameofEntry = this.stubName((InterfaceEntry)this.entry);
        this.stream.println("      " + stubNameofEntry + " stub = new " + stubNameofEntry + " ();");
        this.stream.println("      stub._set_delegate(delegate);");
        this.stream.println("      return stub;");
        this.stream.println("    }");
        this.stream.println("  }");
    }

    private void writeRemoteNarrowForLocal(boolean hasAbstractParent) {
        this.stream.println("  public static " + this.helperType + " narrow (org.omg.CORBA.Object obj)");
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        this.stream.println("    else if (obj instanceof " + this.helperType + ")");
        this.stream.println("      return (" + this.helperType + ")obj;");
        this.stream.println("    else");
        this.stream.println("      throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
    }

    private void writeRemoteNarrowForAbstract(boolean hasAbstractParent) {
        this.stream.print("  public static " + this.helperType + " narrow (java.lang.Object obj)");
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        if (hasAbstractParent) {
            this.stream.println("    else if (obj instanceof org.omg.CORBA.Object)");
            this.stream.println("      return narrow ((org.omg.CORBA.Object) obj);");
        } else {
            this.stream.println("    else if (obj instanceof " + this.helperType + ")");
            this.stream.println("      return (" + this.helperType + ")obj;");
        }
        if (!hasAbstractParent) {
            String stubNameofEntry = this.stubName((InterfaceEntry)this.entry);
            this.stream.println("    else if ((obj instanceof org.omg.CORBA.portable.ObjectImpl) &&");
            this.stream.println("             (((org.omg.CORBA.Object)obj)._is_a (id ()))) {");
            this.stream.println("      org.omg.CORBA.portable.ObjectImpl impl = (org.omg.CORBA.portable.ObjectImpl)obj ;");
            this.stream.println("      org.omg.CORBA.portable.Delegate delegate = impl._get_delegate() ;");
            this.stream.println("      " + stubNameofEntry + " stub = new " + stubNameofEntry + " ();");
            this.stream.println("      stub._set_delegate(delegate);");
            this.stream.println("      return stub;");
            this.stream.println("    }");
        }
        this.stream.println("    throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeUncheckedNarrow() {
        this.writeUncheckedRemoteNarrow();
        this.stream.println();
    }

    protected void writeUncheckedRemoteNarrow() {
        InterfaceEntry ie = (InterfaceEntry)this.entry;
        if (ie.isLocal()) {
            this.writeRemoteUncheckedNarrowForLocal(false);
            return;
        }
        if (ie.isAbstract()) {
            this.writeRemoteUncheckedNarrowForAbstract(false);
            return;
        }
        for (int i = 0; i < ie.derivedFrom().size(); ++i) {
            SymtabEntry parent = (SymtabEntry)ie.derivedFrom().elementAt(i);
            if (!((InterfaceEntry)parent).isAbstract()) continue;
            this.writeRemoteUncheckedNarrowForAbstract(true);
            break;
        }
        this.stream.println("  public static " + this.helperType + " unchecked_narrow (org.omg.CORBA.Object obj)");
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        this.stream.println("    else if (obj instanceof " + this.helperType + ")");
        this.stream.println("      return (" + this.helperType + ")obj;");
        this.stream.println("    else");
        this.stream.println("    {");
        this.stream.println("      org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate ();");
        String stubNameofEntry = this.stubName((InterfaceEntry)this.entry);
        this.stream.println("      " + stubNameofEntry + " stub = new " + stubNameofEntry + " ();");
        this.stream.println("      stub._set_delegate(delegate);");
        this.stream.println("      return stub;");
        this.stream.println("    }");
        this.stream.println("  }");
    }

    private void writeRemoteUncheckedNarrowForLocal(boolean hasAbstractParent) {
        this.stream.println("  public static " + this.helperType + " unchecked_narrow (org.omg.CORBA.Object obj)");
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        this.stream.println("    else if (obj instanceof " + this.helperType + ")");
        this.stream.println("      return (" + this.helperType + ")obj;");
        this.stream.println("    else");
        this.stream.println("      throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
    }

    private void writeRemoteUncheckedNarrowForAbstract(boolean hasAbstractParent) {
        this.stream.print("  public static " + this.helperType + " unchecked_narrow (java.lang.Object obj)");
        this.stream.println("  {");
        this.stream.println("    if (obj == null)");
        this.stream.println("      return null;");
        if (hasAbstractParent) {
            this.stream.println("    else if (obj instanceof org.omg.CORBA.Object)");
            this.stream.println("      return unchecked_narrow ((org.omg.CORBA.Object) obj);");
        } else {
            this.stream.println("    else if (obj instanceof " + this.helperType + ")");
            this.stream.println("      return (" + this.helperType + ")obj;");
        }
        if (!hasAbstractParent) {
            String stubNameofEntry = this.stubName((InterfaceEntry)this.entry);
            this.stream.println("    else if (obj instanceof org.omg.CORBA.portable.ObjectImpl) {");
            this.stream.println("      org.omg.CORBA.portable.ObjectImpl impl = (org.omg.CORBA.portable.ObjectImpl)obj ;");
            this.stream.println("      org.omg.CORBA.portable.Delegate delegate = impl._get_delegate() ;");
            this.stream.println("      " + stubNameofEntry + " stub = new " + stubNameofEntry + " ();");
            this.stream.println("      stub._set_delegate(delegate);");
            this.stream.println("      return stub;");
            this.stream.println("    }");
        }
        this.stream.println("    throw new org.omg.CORBA.BAD_PARAM ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetID() {
        if (!Util.IDLEntity(this.entry)) {
            return;
        }
        this.stream.println("  public String get_id ()");
        this.stream.println("  {");
        this.stream.println("    return _id;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetType() {
        if (!Util.IDLEntity(this.entry)) {
            return;
        }
        this.stream.println("  public org.omg.CORBA.TypeCode get_type ()");
        this.stream.println("  {");
        this.stream.println("    return type ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetClass() {
        this.stream.println("  public Class get_class ()");
        this.stream.println("  {");
        this.stream.println("    return " + this.helperType + ".class;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetInstance() {
        this.stream.println("  public static org.omg.CORBA.portable.ValueHelper get_instance ()");
        this.stream.println("  {");
        this.stream.println("    return helper;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeGetSafeBaseIds() {
        this.stream.println("  public String[] get_truncatable_base_ids ()");
        this.stream.println("  {");
        this.stream.println("    return _truncatable_ids;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected String stubName(InterfaceEntry entry) {
        String name = entry.container().name().equals("") ? "_" + entry.name() + "Stub" : Util.containerFullName(entry.container()) + "._" + entry.name() + "Stub";
        return name.replace('/', '.');
    }
}

