/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import java.util.Optional;

public class RuntimeKafkaSinkConfiguration {
    private final int partition;
    private final Optional<String> key;
    private final Optional<String> cloudEventSubject;
    private final String propagateHeaders;
    private final Optional<String> cloudEventsDataContentType;
    private final Optional<String> cloudEventsDataSchema;
    private final Optional<String> cloudEventSource;
    private final Optional<String> cloudEventsType;
    private final Boolean cloudEventsInsertTimestamp;
    private final Boolean propagateRecordKey;
    private final Boolean tracingEnabled;

    private RuntimeKafkaSinkConfiguration(int partition, Optional<String> key, Optional<String> cloudEventSubject, String propagateHeaders, Optional<String> cloudEventsDataContentType, Optional<String> cloudEventsDataSchema, Optional<String> cloudEventSource, Optional<String> cloudEventsType, Boolean cloudEventsInsertTimestamp, Boolean propagateRecordKey, Boolean tracingEnabled) {
        this.partition = partition;
        this.key = key;
        this.cloudEventSubject = cloudEventSubject;
        this.propagateHeaders = propagateHeaders;
        this.cloudEventsDataContentType = cloudEventsDataContentType;
        this.cloudEventsDataSchema = cloudEventsDataSchema;
        this.cloudEventSource = cloudEventSource;
        this.cloudEventsType = cloudEventsType;
        this.cloudEventsInsertTimestamp = cloudEventsInsertTimestamp;
        this.propagateRecordKey = propagateRecordKey;
        this.tracingEnabled = tracingEnabled;
    }

    public static RuntimeKafkaSinkConfiguration buildFromConfiguration(KafkaConnectorOutgoingConfiguration configuration) {
        return new RuntimeKafkaSinkConfiguration(configuration.getPartition(), configuration.getKey(), configuration.getCloudEventsSubject(), configuration.getPropagateHeaders(), configuration.getCloudEventsDataContentType(), configuration.getCloudEventsDataSchema(), configuration.getCloudEventsSource(), configuration.getCloudEventsType(), configuration.getCloudEventsInsertTimestamp(), configuration.getPropagateRecordKey(), configuration.getTracingEnabled());
    }

    public int getPartition() {
        return this.partition;
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public Optional<String> getCloudEventsSubject() {
        return this.cloudEventSubject;
    }

    public String getPropagateHeaders() {
        return this.propagateHeaders;
    }

    public Optional<String> getCloudEventsDataContentType() {
        return this.cloudEventsDataContentType;
    }

    public Optional<String> getCloudEventsDataSchema() {
        return this.cloudEventsDataSchema;
    }

    public Optional<String> getCloudEventsSource() {
        return this.cloudEventSource;
    }

    public Optional<String> getCloudEventsType() {
        return this.cloudEventsType;
    }

    public Boolean getCloudEventsInsertTimestamp() {
        return this.cloudEventsInsertTimestamp;
    }

    public Boolean getPropagateRecordKey() {
        return this.propagateRecordKey;
    }

    public Boolean getTracingEnabled() {
        return this.tracingEnabled;
    }
}

