/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumerRebalanceListener;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;

public class RebalanceListeners {
    static ConsumerRebalanceListener createRebalanceListener(ReactiveKafkaConsumer<?, ?> reactiveKafkaConsumer, String consumerGroup, KafkaConsumerRebalanceListener listener, KafkaCommitHandler commitHandler) {
        return new WrappedConsumerRebalanceListener(consumerGroup, listener, reactiveKafkaConsumer, commitHandler);
    }

    public static KafkaConsumerRebalanceListener findMatchingListener(KafkaConnectorIncomingConfiguration config, String consumerGroup, Instance<KafkaConsumerRebalanceListener> instances) {
        return config.getConsumerRebalanceListenerName().map(name -> {
            KafkaLogging.log.loadingConsumerRebalanceListenerFromConfiguredName((String)name);
            Instance matching = instances.select(new Annotation[]{Identifier.Literal.of((String)name)});
            if (matching.isUnsatisfied() && !(matching = instances.select(new Annotation[]{NamedLiteral.of((String)name)})).isUnsatisfied()) {
                ProviderLogging.log.deprecatedNamed();
            }
            if (matching.isUnsatisfied()) {
                throw KafkaExceptions.ex.unableToFindRebalanceListener((String)name, config.getChannel());
            }
            if (matching.stream().count() > 1L) {
                throw KafkaExceptions.ex.unableToFindRebalanceListener((String)name, config.getChannel(), (int)matching.stream().count());
            }
            if (matching.stream().count() == 1L) {
                return Optional.of((KafkaConsumerRebalanceListener)matching.get());
            }
            return Optional.empty();
        }).orElseGet(() -> {
            Instance matching = instances.select(new Annotation[]{Identifier.Literal.of((String)consumerGroup)});
            if (matching.isUnsatisfied() && !(matching = instances.select(new Annotation[]{NamedLiteral.of((String)consumerGroup)})).isUnsatisfied()) {
                ProviderLogging.log.deprecatedNamed();
            }
            if (!matching.isUnsatisfied()) {
                KafkaLogging.log.loadingConsumerRebalanceListenerFromGroupId(consumerGroup);
                return Optional.of((KafkaConsumerRebalanceListener)matching.get());
            }
            return Optional.empty();
        }).orElse(null);
    }

    public static class WrappedConsumerRebalanceListener
    implements ConsumerRebalanceListener {
        private final String consumerGroup;
        private final KafkaConsumerRebalanceListener listener;
        private final ReactiveKafkaConsumer<?, ?> reactiveKafkaConsumer;
        private final KafkaCommitHandler commitHandler;

        public WrappedConsumerRebalanceListener(String consumerGroup, KafkaConsumerRebalanceListener listener, ReactiveKafkaConsumer<?, ?> reactiveKafkaConsumer, KafkaCommitHandler commitHandler) {
            this.consumerGroup = consumerGroup;
            this.listener = listener;
            this.reactiveKafkaConsumer = reactiveKafkaConsumer;
            this.commitHandler = commitHandler;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            KafkaLogging.log.executingConsumerRevokedRebalanceListener(this.consumerGroup);
            try {
                this.reactiveKafkaConsumer.removeFromQueueRecordsFromTopicPartitions(partitions);
                this.commitHandler.partitionsRevoked(partitions);
                if (this.listener != null) {
                    this.listener.onPartitionsRevoked(this.reactiveKafkaConsumer.unwrap(), partitions);
                    KafkaLogging.log.executedConsumerRevokedRebalanceListener(this.consumerGroup);
                }
            }
            catch (RuntimeException e) {
                KafkaLogging.log.unableToExecuteConsumerRevokedRebalanceListener(this.consumerGroup, e);
                throw e;
            }
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            try {
                if (this.reactiveKafkaConsumer.isPaused()) {
                    this.reactiveKafkaConsumer.unwrap().pause(partitions);
                }
                this.commitHandler.partitionsAssigned(partitions);
                if (this.listener != null) {
                    this.listener.onPartitionsAssigned(this.reactiveKafkaConsumer.unwrap(), partitions);
                    KafkaLogging.log.executedConsumerAssignedRebalanceListener(this.consumerGroup);
                }
            }
            catch (RuntimeException e) {
                KafkaLogging.log.reEnablingConsumerForGroup(this.consumerGroup);
                throw e;
            }
        }
    }
}

