/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.lang.reflect.Method;
import java.time.Instant;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.ejb.cache.timer.AbstractTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimeoutMatcher;
import org.wildfly.clustering.ejb.cache.timer.ImmutableScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerOperatorFactory;
import org.wildfly.clustering.ejb.cache.timer.TimeoutDescriptor;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;

public class ScheduleTimerMetaDataEntry<C>
extends AbstractTimerMetaDataEntry<C>
implements ImmutableScheduleTimerMetaDataEntry<C> {
    private final ImmutableScheduleExpression expression;
    private final Predicate<Method> timeoutMatcher;
    private volatile UnaryOperator<Instant> operator = null;

    public ScheduleTimerMetaDataEntry(C context, ScheduleTimerConfiguration config) {
        this(context, config, DefaultTimeoutMatcher.INSTANCE);
    }

    public ScheduleTimerMetaDataEntry(C context, ScheduleTimerConfiguration config, Method method) {
        this(context, config, new TimeoutDescriptor(method));
    }

    private ScheduleTimerMetaDataEntry(C context, ScheduleTimerConfiguration config, Predicate<Method> timeoutMatcher) {
        this(context, config, timeoutMatcher, ScheduleTimerOperatorFactory.INSTANCE.createOperator(config.getScheduleExpression()));
    }

    private ScheduleTimerMetaDataEntry(C context, ScheduleTimerConfiguration config, Predicate<Method> timeoutMatcher, UnaryOperator<Instant> operator) {
        this(context, (Instant)operator.apply(null), config.getScheduleExpression(), timeoutMatcher, operator);
    }

    ScheduleTimerMetaDataEntry(C context, Instant start, ImmutableScheduleExpression expression, Predicate<Method> timeoutMatcher) {
        this(context, start, expression, timeoutMatcher, null);
    }

    private ScheduleTimerMetaDataEntry(C context, Instant start, ImmutableScheduleExpression expression, Predicate<Method> timeoutMatcher, UnaryOperator<Instant> operator) {
        super(context, start);
        this.expression = expression;
        this.timeoutMatcher = timeoutMatcher;
        this.operator = operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnaryOperator<Instant> getOperator() {
        if (this.operator == null) {
            ScheduleTimerMetaDataEntry scheduleTimerMetaDataEntry = this;
            synchronized (scheduleTimerMetaDataEntry) {
                if (this.operator == null) {
                    this.operator = ScheduleTimerOperatorFactory.INSTANCE.createOperator(this.expression);
                }
            }
        }
        return this.operator;
    }

    public ImmutableScheduleExpression getScheduleExpression() {
        return this.expression;
    }

    @Override
    public Predicate<Method> getTimeoutMatcher() {
        return this.timeoutMatcher;
    }

    @Override
    public Instant apply(Instant lastTimeout) {
        return (Instant)this.getOperator().apply(lastTimeout);
    }

    @Override
    protected RemappableTimerMetaDataEntry<C> clone() {
        return new ScheduleTimerMetaDataEntry(this.getContext(), this.getStart(), this.expression, this.timeoutMatcher, this.operator);
    }
}

