/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.metrics.MetricRegistration;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.registry.WildFlyRegistry;

class MicrometerDeploymentService
implements Service {
    private final Resource rootResource;
    private final ManagementResourceRegistration managementResourceRegistration;
    private final PathAddress deploymentAddress;
    private final Supplier<MicrometerCollector> metricCollector;
    private final Supplier<WildFlyRegistry> registrySupplier;
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;
    private volatile MetricRegistration registration;

    static void install(ServiceTarget serviceTarget, DeploymentPhaseContext deploymentPhaseContext, Resource rootResource, ManagementResourceRegistration managementResourceRegistration, Supplier<WildFlyRegistry> registrySupplier, boolean exposeAnySubsystem, List<String> exposedSubsystems) {
        MicrometerExtensionLogger.MICROMETER_LOGGER.processingDeployment();
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        PathAddress deploymentAddress = MicrometerDeploymentService.createDeploymentAddressPrefix(deploymentUnit);
        ServiceBuilder sb = serviceTarget.addService(deploymentUnit.getServiceName().append(new String[]{".micrometer-metrics"}));
        Supplier metricCollectorSupplier = sb.requires(MicrometerSubsystemDefinition.MICROMETER_COLLECTOR);
        sb.requires(DeploymentCompleteServiceProcessor.serviceName((ServiceName)deploymentUnit.getServiceName()));
        sb.setInstance((Service)new MicrometerDeploymentService(rootResource, managementResourceRegistration, deploymentAddress, metricCollectorSupplier, registrySupplier, exposeAnySubsystem, exposedSubsystems)).install();
    }

    private MicrometerDeploymentService(Resource rootResource, ManagementResourceRegistration managementResourceRegistration, PathAddress deploymentAddress, Supplier<MicrometerCollector> metricCollectorSupplier, Supplier<WildFlyRegistry> registrySupplier, boolean exposeAnySubsystem, List<String> exposedSubsystems) {
        this.rootResource = rootResource;
        this.managementResourceRegistration = managementResourceRegistration;
        this.deploymentAddress = deploymentAddress;
        this.metricCollector = metricCollectorSupplier;
        this.registrySupplier = registrySupplier;
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
    }

    private static PathAddress createDeploymentAddressPrefix(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return PathAddress.pathAddress((String)"deployment", (String)((String)deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME)));
        }
        return MicrometerDeploymentService.createDeploymentAddressPrefix(deploymentUnit.getParent()).append("subdeployment", deploymentUnit.getName());
    }

    public void start(StartContext context) {
        this.registration = this.metricCollector.get().collectResourceMetrics(this.rootResource, (ImmutableManagementResourceRegistration)this.managementResourceRegistration, arg_0 -> ((PathAddress)this.deploymentAddress).append(arg_0), this.exposeAnySubsystem, this.exposedSubsystems);
    }

    public void stop(StopContext context) {
        this.registration.unregister();
    }
}

