/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.InternalClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.url.internal.InternalUrlAttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalUrlAttributesExtractor<REQUEST> internalUrlExtractor;
    private final InternalNetServerAttributesExtractor<REQUEST, RESPONSE> internalNetExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST, RESPONSE> internalServerExtractor;
    private final InternalClientAttributesExtractor<REQUEST, RESPONSE> internalClientExtractor;
    private final Function<Context, String> httpRouteGetter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter).build();
    }

    @Deprecated
    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, httpAttributesGetter);
    }

    @Deprecated
    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder) {
        super(builder.httpAttributesGetter, builder.capturedRequestHeaders, builder.capturedResponseHeaders, builder.knownMethods);
        this.internalUrlExtractor = builder.buildUrlExtractor();
        this.internalNetExtractor = builder.buildNetExtractor();
        this.internalNetworkExtractor = builder.buildNetworkExtractor();
        this.internalServerExtractor = builder.buildServerExtractor();
        this.internalClientExtractor = builder.buildClientExtractor();
        this.httpRouteGetter = builder.httpRouteGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.internalUrlExtractor.onStart(attributes, request);
        this.internalNetExtractor.onStart(attributes, request);
        this.internalServerExtractor.onStart(attributes, request);
        this.internalClientExtractor.onStart(attributes, request);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_ROUTE, (Object)((HttpServerAttributesGetter)this.getter).getHttpRoute(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        this.internalServerExtractor.onEnd(attributes, request, response);
        this.internalClientExtractor.onEnd(attributes, request, response);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_ROUTE, (Object)this.httpRouteGetter.apply(context));
    }

    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }
}

