/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;

final class ClientAddressAndPortExtractor<REQUEST>
implements FallbackAddressPortExtractor<REQUEST> {
    private final HttpServerAttributesGetter<REQUEST, ?> getter;

    ClientAddressAndPortExtractor(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(FallbackAddressPortExtractor.AddressPortSink sink, REQUEST request) {
        String forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
            sink.setAddress(forwarded);
            return;
        }
        forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            sink.setAddress(ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded));
        }
    }
}

