/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.infinispan.persistence.jdbc.DataSourceConnectionFactoryConfigurationBuilder;
import org.jboss.as.clustering.infinispan.persistence.jdbc.JDBCStoreConfiguration;
import org.jboss.as.clustering.infinispan.persistence.jdbc.JDBCStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class JDBCStoreServiceConfigurator
extends StoreServiceConfigurator<JDBCStoreConfiguration, JDBCStoreConfigurationBuilder> {
    private final SupplierDependency<TableManipulationConfiguration> table;
    private volatile SupplierDependency<List<Module>> modules;
    private volatile SupplierDependency<DataSource> dataSource;
    private volatile DatabaseType dialect;

    JDBCStoreServiceConfigurator(PathAddress address) {
        super(address, JDBCStoreConfigurationBuilder.class);
        PathAddress cacheAddress = address.getParent();
        PathAddress containerAddress = cacheAddress.getParent();
        this.table = new ServiceSupplierDependency(CacheComponent.STRING_TABLE.getServiceName(cacheAddress));
        this.modules = new ServiceSupplierDependency(CacheContainerComponent.MODULES.getServiceName(containerAddress));
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(new CompositeDependency(new Dependency[]{this.table, this.modules, this.dataSource}).register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String dataSource = JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.dataSource = new ServiceSupplierDependency(CommonUnaryRequirement.DATA_SOURCE.getServiceName(context, dataSource));
        this.dialect = Optional.ofNullable(JDBCStoreResourceDefinition.Attribute.DIALECT.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull()).map(DatabaseType::valueOf).orElse(null);
        return super.configure(context, model);
    }

    @Override
    public void accept(JDBCStoreConfigurationBuilder builder) {
        builder.table().read((TableManipulationConfiguration)this.table.get());
        TwoWayKey2StringMapper mapper = this.findMapper();
        if (mapper != null) {
            builder.key2StringMapper(mapper.getClass());
        }
        ((DataSourceConnectionFactoryConfigurationBuilder)((JDBCStoreConfigurationBuilder)((JDBCStoreConfigurationBuilder)((JDBCStoreConfigurationBuilder)builder.segmented(true)).transactional(false)).dialect(this.dialect)).connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSourceDependency((Supplier<DataSource>)this.dataSource);
    }

    private TwoWayKey2StringMapper findMapper() {
        for (Module module : (List)this.modules.get()) {
            Iterator iterator = module.loadService(TwoWayKey2StringMapper.class).iterator();
            if (!iterator.hasNext()) continue;
            TwoWayKey2StringMapper mapper = (TwoWayKey2StringMapper)iterator.next();
            return mapper;
        }
        return null;
    }
}

