/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.persistence.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfigurationBuilder;
import org.infinispan.persistence.keymappers.Key2StringMapper;
import org.jboss.as.clustering.infinispan.persistence.jdbc.JDBCStoreConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JDBCStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JDBCStoreConfiguration, JDBCStoreConfigurationBuilder> {
    private TableConfigurationBuilder table = new TableConfigurationBuilder(this);

    public JDBCStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, JDBCStoreConfiguration.attributeDefinitionSet());
    }

    public TableConfigurationBuilder table() {
        return this.table;
    }

    public JDBCStoreConfigurationBuilder key2StringMapper(Class<? extends Key2StringMapper> mapperClass) {
        this.attributes.attribute(JDBCStoreConfiguration.KEY2STRING_MAPPER).set((Object)mapperClass.getName());
        return this;
    }

    public JDBCStoreConfigurationBuilder self() {
        return this;
    }

    public JDBCStoreConfiguration create() {
        return new JDBCStoreConfiguration(this.attributes.protect(), this.async.create(), (ConnectionFactoryConfiguration)this.connectionFactory.create(), this.table.create());
    }

    public JDBCStoreConfigurationBuilder read(JDBCStoreConfiguration template, Combine combine) {
        super.read((AbstractJdbcStoreConfiguration)template, combine);
        this.table.read(template.table(), combine);
        return this;
    }

    static void validateIfSet(AttributeSet attributes, AttributeDefinition<?> ... definitions) {
        for (AttributeDefinition<?> definition : definitions) {
            String value = (String)attributes.attribute(definition).get();
            if (value != null && !value.isEmpty()) continue;
            throw Log.CONFIG.tableManipulationAttributeNotSet(attributes.getName(), definition.name());
        }
    }

    public static class TableConfigurationBuilder
    extends AbstractJdbcStoreConfigurationChildBuilder<JDBCStoreConfigurationBuilder>
    implements Builder<TableManipulationConfiguration>,
    Self<TableConfigurationBuilder> {
        private final AttributeSet attributes = new AttributeSet(TableManipulationConfiguration.class, (Enum)Element.TABLE_JDBC_STORE, new AttributeDefinition[]{TableManipulationConfiguration.TABLE_NAME_PREFIX, TableManipulationConfiguration.BATCH_SIZE, TableManipulationConfiguration.FETCH_SIZE, TableManipulationConfiguration.CREATE_ON_START, TableManipulationConfiguration.DROP_ON_EXIT});
        private final DataColumnConfigurationBuilder dataColumn = TableConfigurationBuilder.newInstance(DataColumnConfigurationBuilder.class);
        private final IdColumnConfigurationBuilder idColumn = TableConfigurationBuilder.newInstance(IdColumnConfigurationBuilder.class);
        private final TimestampColumnConfigurationBuilder timeStampColumn = TableConfigurationBuilder.newInstance(TimestampColumnConfigurationBuilder.class);
        private final SegmentColumnConfigurationBuilder segmentColumn;

        private static <T> T newInstance(Class<T> targetClass) {
            return TableConfigurationBuilder.newInstance(targetClass, List.of(), List.of());
        }

        private static <T, C, V extends C> T newInstance(Class<T> targetClass, Class<C> argumentClass, V argument) {
            return TableConfigurationBuilder.newInstance(targetClass, List.of(argumentClass), List.of(argument));
        }

        private static <T> T newInstance(final Class<T> targetClass, final List<Class<?>> argumentClasses, final List<Object> arguments) {
            return (T)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<T>(){

                @Override
                public T run() {
                    try {
                        Constructor constructor = targetClass.getDeclaredConstructor((Class[])argumentClasses.toArray(Class[]::new));
                        constructor.setAccessible(true);
                        return constructor.newInstance(arguments.toArray());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        }

        TableConfigurationBuilder(JDBCStoreConfigurationBuilder builder) {
            super((AbstractJdbcStoreConfigurationBuilder)builder);
            this.segmentColumn = TableConfigurationBuilder.newInstance(SegmentColumnConfigurationBuilder.class, AbstractJdbcStoreConfigurationBuilder.class, builder);
        }

        public TableConfigurationBuilder self() {
            return this;
        }

        public AttributeSet attributes() {
            return this.attributes;
        }

        public TableConfigurationBuilder fetchSize(int fetchSize) {
            this.attributes.attribute(TableManipulationConfiguration.FETCH_SIZE).set((Object)fetchSize);
            return this;
        }

        public TableConfigurationBuilder tableNamePrefix(String tableNamePrefix) {
            this.attributes.attribute(TableManipulationConfiguration.TABLE_NAME_PREFIX).set((Object)tableNamePrefix);
            return this;
        }

        public TableConfigurationBuilder createOnStart(boolean createOnStart) {
            this.attributes.attribute(TableManipulationConfiguration.CREATE_ON_START).set((Object)createOnStart);
            return this.self();
        }

        public TableConfigurationBuilder dropOnExit(boolean dropOnExit) {
            this.attributes.attribute(TableManipulationConfiguration.DROP_ON_EXIT).set((Object)dropOnExit);
            return this.self();
        }

        public TableConfigurationBuilder idColumnName(String idColumnName) {
            this.idColumn.idColumnName(idColumnName);
            return this.self();
        }

        public TableConfigurationBuilder idColumnType(String idColumnType) {
            this.idColumn.idColumnType(idColumnType);
            return this.self();
        }

        public TableConfigurationBuilder dataColumnName(String dataColumnName) {
            this.dataColumn.dataColumnName(dataColumnName);
            return this.self();
        }

        public TableConfigurationBuilder dataColumnType(String dataColumnType) {
            this.dataColumn.dataColumnType(dataColumnType);
            return this.self();
        }

        public TableConfigurationBuilder timestampColumnName(String timestampColumnName) {
            this.timeStampColumn.dataColumnName(timestampColumnName);
            return this.self();
        }

        public TableConfigurationBuilder timestampColumnType(String timestampColumnType) {
            this.timeStampColumn.dataColumnType(timestampColumnType);
            return this.self();
        }

        public TableConfigurationBuilder segmentColumnName(String segmentColumnName) {
            this.segmentColumn.columnName(segmentColumnName);
            return this.self();
        }

        public TableConfigurationBuilder segmentColumnType(String segmentColumnType) {
            this.segmentColumn.columnType(segmentColumnType);
            return this.self();
        }

        public void validate() {
            JDBCStoreConfigurationBuilder.validateIfSet(this.attributes, TableManipulationConfiguration.TABLE_NAME_PREFIX);
            this.idColumn.validate();
            this.dataColumn.validate();
            this.timeStampColumn.validate();
            this.segmentColumn.validate();
        }

        public void validate(GlobalConfiguration globalConfig) {
        }

        public TableManipulationConfiguration create() {
            return TableConfigurationBuilder.newInstance(TableManipulationConfiguration.class, List.of(AttributeSet.class, IdColumnConfiguration.class, DataColumnConfiguration.class, TimestampColumnConfiguration.class, SegmentColumnConfiguration.class), List.of(this.attributes.protect(), this.idColumn.create(), this.dataColumn.create(), this.timeStampColumn.create(), this.segmentColumn.create()));
        }

        public TableConfigurationBuilder read(TableManipulationConfiguration template, Combine combine) {
            this.attributes.read(template.attributes(), combine);
            this.idColumn.read(template.idColumnConfiguration(), combine);
            this.dataColumn.read(template.dataColumnConfiguration(), combine);
            this.timeStampColumn.read(template.timeStampColumnConfiguration(), combine);
            this.segmentColumn.read(template.segmentColumnConfiguration(), combine);
            return this;
        }
    }
}

