/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.replay;

import io.smallrye.mutiny.helpers.ParameterValidation;

public class AppendOnlyReplayList {
    private static final Cell SENTINEL_END = new Cell(null, null);
    private static final Cell SENTINEL_EMPTY = new Cell(null, SENTINEL_END);
    private final long itemsToReplay;
    private long numberOfItemsRecorded = 0L;
    private volatile Cell head = SENTINEL_EMPTY;
    private volatile Cell tail = SENTINEL_EMPTY;

    public AppendOnlyReplayList(long numberOfItemsToReplay) {
        this(numberOfItemsToReplay, null);
    }

    public AppendOnlyReplayList(long numberOfItemsToReplay, Iterable<?> seed) {
        assert (numberOfItemsToReplay > 0L);
        this.itemsToReplay = numberOfItemsToReplay;
        if (seed != null) {
            seed.forEach(this::push);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        assert (!(this.tail.value instanceof Terminal));
        Cell newCell = new Cell(ParameterValidation.nonNull(item, "item"), SENTINEL_END);
        if (this.head == SENTINEL_EMPTY) {
            this.head = newCell;
        } else {
            this.tail.next = newCell;
        }
        this.tail = newCell;
        if (this.itemsToReplay != Long.MAX_VALUE && !(item instanceof Terminal)) {
            ++this.numberOfItemsRecorded;
            if (this.numberOfItemsRecorded > this.itemsToReplay) {
                AppendOnlyReplayList appendOnlyReplayList = this;
                synchronized (appendOnlyReplayList) {
                    this.head = this.head.next;
                }
            }
        }
    }

    public void pushFailure(Throwable failure) {
        this.push(new Failure(failure));
    }

    public void pushCompletion() {
        this.push(new Completion());
    }

    public Cursor newCursor() {
        return new Cursor();
    }

    private static class Cell {
        final Object value;
        volatile Cell next;

        Cell(Object value, Cell next) {
            this.value = value;
            this.next = next;
        }
    }

    private static final class Failure
    extends Terminal {
        final Throwable failure;

        Failure(Throwable failure) {
            this.failure = failure;
        }
    }

    private static final class Completion
    extends Terminal {
        private Completion() {
        }
    }

    private static abstract class Terminal {
        private Terminal() {
        }
    }

    public class Cursor {
        private Cell current = SENTINEL_EMPTY;
        private boolean start = true;
        private boolean currentHasBeenRead = false;

        public boolean hasNext() {
            if (this.current == SENTINEL_EMPTY) {
                Cell currentHead = AppendOnlyReplayList.this.head;
                if (currentHead != SENTINEL_EMPTY) {
                    this.current = currentHead;
                    return true;
                }
                return false;
            }
            if (!this.currentHasBeenRead) {
                return true;
            }
            return this.current.next != SENTINEL_END;
        }

        public void moveToNext() {
            if (this.start) {
                this.start = false;
                return;
            }
            assert (this.current.next != SENTINEL_END);
            this.current = this.current.next;
            this.currentHasBeenRead = false;
        }

        public Object read() {
            this.currentHasBeenRead = true;
            return this.current.value;
        }

        public boolean hasReachedCompletion() {
            return this.current.value instanceof Completion;
        }

        public boolean hasReachedFailure() {
            return this.current.value instanceof Failure;
        }

        public Throwable readFailure() {
            this.currentHasBeenRead = true;
            return ((Failure)this.current.value).failure;
        }

        public void readCompletion() {
            this.currentHasBeenRead = true;
        }
    }
}

