/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.ejb.EjbConstants;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;

public class HttpDiscoveryHandler
extends RemoteHTTPHandler {
    private final Set<EJBModuleIdentifier> availableModules = new HashSet<EJBModuleIdentifier>();
    private final HttpServiceConfig httpServiceConfig;

    @Deprecated
    public HttpDiscoveryHandler(ExecutorService executorService, Association association) {
        this(executorService, association, HttpServiceConfig.DEFAULT);
    }

    public HttpDiscoveryHandler(ExecutorService executorService, Association association, HttpServiceConfig httpServiceConfig) {
        super(executorService);
        association.registerModuleAvailabilityListener(new ModuleAvailabilityListener(){

            public void moduleAvailable(List<EJBModuleIdentifier> modules) {
                HttpDiscoveryHandler.this.availableModules.addAll(modules);
            }

            public void moduleUnavailable(List<EJBModuleIdentifier> modules) {
                HttpDiscoveryHandler.this.availableModules.removeAll(modules);
            }
        });
        this.httpServiceConfig = httpServiceConfig;
    }

    @Override
    protected void handleInternal(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, EjbConstants.EJB_DISCOVERY_RESPONSE.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Marshaller marshaller = this.httpServiceConfig.getHttpMarshallerFactory(exchange).createMarshaller((ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
        marshaller.start((ByteOutput)new NoFlushByteOutput(Marshalling.createByteOutput((OutputStream)out)));
        marshaller.writeInt(this.availableModules.size());
        for (EJBModuleIdentifier ejbModuleIdentifier : this.availableModules) {
            marshaller.writeObject((Object)ejbModuleIdentifier);
        }
        marshaller.finish();
        marshaller.flush();
        exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
    }
}

