/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.core.stats.impl.SearchStatsRetriever;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetClusterExecutorAction;

final class SecurityActions {
    private SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)(System.getSecurityManager() != null ? AccessController.doPrivileged(action) : Security.doPrivileged(action));
    }

    static Cache<?, ?> getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        return (Cache)SecurityActions.doPrivileged(new GetCacheAction(cacheManager, cacheName));
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getComponentRegistry());
    }

    public static SearchStatsRetriever getStatsRetriever(Cache<?, ?> cache) {
        return (SearchStatsRetriever)SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache()).getComponent(SearchStatsRetriever.class);
    }

    static ClusterExecutor getClusterExecutor(Cache<?, ?> cache) {
        GetClusterExecutorAction action = new GetClusterExecutorAction(cache);
        return (ClusterExecutor)SecurityActions.doPrivileged(action);
    }
}

