/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ImportHandler;
import jakarta.el.ValueExpression;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.el.ExpressionEvaluator;
import jakarta.servlet.jsp.el.NotFoundELResolver;
import jakarta.servlet.jsp.el.VariableResolver;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.el.ELContextImpl;
import org.apache.jasper.el.ExpressionEvaluatorImpl;
import org.apache.jasper.el.VariableResolverImpl;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.JspContextWrapper;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDirectives;
import org.apache.jasper.runtime.JspSourceImports;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;
import org.apache.jasper.security.SecurityUtil;

public class PageContextImpl
extends PageContext {
    private static final JspFactory jspf = JspFactory.getDefaultFactory();
    private BodyContentImpl[] outs = new BodyContentImpl[0];
    private int depth = -1;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspApplicationContextImpl applicationContext;
    private String errorPageURL;
    private final transient HashMap<String, Object> attributes = new HashMap(16);
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient HttpSession session;
    private transient ELContextImpl elContext;
    private boolean isIncluded;
    private transient JspWriter out;
    private transient JspWriterImpl baseOut;

    PageContextImpl() {
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.errorPageURL = errorPageURL;
        this.request = request;
        this.response = response;
        this.applicationContext = JspApplicationContextImpl.getInstance(this.context);
        if (request instanceof HttpServletRequest && needsSession) {
            this.session = ((HttpServletRequest)request).getSession();
        }
        if (needsSession && this.session == null) {
            throw JasperMessages.MESSAGES.pageNeedsSession();
        }
        this.depth = -1;
        if (bufferSize == -1) {
            bufferSize = Constants.DEFAULT_BUFFER_SIZE;
        }
        if (this.baseOut == null) {
            this.baseOut = new JspWriterImpl(response, bufferSize, autoFlush);
        } else {
            this.baseOut.init(response, bufferSize, autoFlush);
        }
        this.out = this.baseOut;
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        this.setAttribute("jakarta.servlet.jsp.jspRequest", request);
        this.setAttribute("jakarta.servlet.jsp.jspResponse", response);
        if (this.session != null) {
            this.setAttribute("jakarta.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("jakarta.servlet.jsp.jspPage", servlet);
        this.setAttribute("jakarta.servlet.jsp.jspConfig", this.config);
        this.setAttribute("jakarta.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("jakarta.servlet.jsp.jspApplication", this.context);
        this.isIncluded = request.getAttribute("jakarta.servlet.include.servlet_path") != null;
    }

    public void release() {
        this.out = this.baseOut;
        try {
            if (this.isIncluded) {
                ((JspWriterImpl)this.out).flushBuffer();
            } else {
                ((JspWriterImpl)this.out).flushBuffer();
            }
        }
        catch (IOException ex) {
            throw JasperMessages.MESSAGES.errorFlushingData(ex);
        }
        finally {
            this.servlet = null;
            this.config = null;
            this.context = null;
            this.applicationContext = null;
            this.elContext = null;
            this.errorPageURL = null;
            this.request = null;
            this.response = null;
            this.depth = -1;
            this.baseOut.recycle();
            this.session = null;
            this.attributes.clear();
            for (BodyContentImpl body : this.outs) {
                body.recycle();
            }
        }
    }

    public Object getAttribute(final String name) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return PageContextImpl.this.doGetAttribute(name);
                }
            });
        }
        return this.doGetAttribute(name);
    }

    private Object doGetAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getAttribute(final String name, final int scope) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return PageContextImpl.this.doGetAttribute(name, scope);
                }
            });
        }
        return this.doGetAttribute(name, scope);
    }

    private Object doGetAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                return this.attributes.get(name);
            }
            case 2: {
                return this.request.getAttribute(name);
            }
            case 3: {
                if (this.session == null) {
                    throw JasperMessages.MESSAGES.cannotUseSessionScope();
                }
                return this.session.getAttribute(name);
            }
            case 4: {
                return this.context.getAttribute(name);
            }
        }
        throw JasperMessages.MESSAGES.invalidScope();
    }

    public void setAttribute(final String name, final Object attribute) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doSetAttribute(name, attribute);
                    return null;
                }
            });
        } else {
            this.doSetAttribute(name, attribute);
        }
    }

    private void doSetAttribute(String name, Object attribute) {
        if (attribute != null) {
            this.attributes.put(name, attribute);
        } else {
            this.removeAttribute(name, 1);
        }
    }

    public void setAttribute(final String name, final Object o, final int scope) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doSetAttribute(name, o, scope);
                    return null;
                }
            });
        } else {
            this.doSetAttribute(name, o, scope);
        }
    }

    private void doSetAttribute(String name, Object o, int scope) {
        block8: {
            block7: {
                if (o == null) break block7;
                switch (scope) {
                    case 1: {
                        this.attributes.put(name, o);
                        break block8;
                    }
                    case 2: {
                        this.request.setAttribute(name, o);
                        break block8;
                    }
                    case 3: {
                        if (this.session == null) {
                            throw JasperMessages.MESSAGES.cannotUseSessionScope();
                        }
                        this.session.setAttribute(name, o);
                        break block8;
                    }
                    case 4: {
                        this.context.setAttribute(name, o);
                        break block8;
                    }
                    default: {
                        throw JasperMessages.MESSAGES.invalidScope();
                    }
                }
            }
            this.removeAttribute(name, scope);
        }
    }

    public void removeAttribute(final String name, final int scope) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doRemoveAttribute(name, scope);
                    return null;
                }
            });
        } else {
            this.doRemoveAttribute(name, scope);
        }
    }

    private void doRemoveAttribute(String name, int scope) {
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw JasperMessages.MESSAGES.cannotUseSessionScope();
                }
                this.session.removeAttribute(name);
                break;
            }
            case 4: {
                this.context.removeAttribute(name);
                break;
            }
            default: {
                throw JasperMessages.MESSAGES.invalidScope();
            }
        }
    }

    public int getAttributesScope(final String name) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return PageContextImpl.this.doGetAttributeScope(name);
                }
            });
        }
        return this.doGetAttributeScope(name);
    }

    private int doGetAttributeScope(String name) {
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null) {
            try {
                if (this.session.getAttribute(name) != null) {
                    return 3;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (this.context.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(final String name) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (name == null) {
                        throw JasperMessages.MESSAGES.nullAttributeName();
                    }
                    return PageContextImpl.this.doFindAttribute(name);
                }
            });
        }
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        return this.doFindAttribute(name);
    }

    private Object doFindAttribute(String name) {
        Object o = this.attributes.get(name);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(name);
        if (o != null) {
            return o;
        }
        if (this.session != null) {
            try {
                o = this.session.getAttribute(name);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (o != null) {
                return o;
            }
        }
        return this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNamesInScope(final int scope) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Enumeration<String>>(){

                @Override
                public Enumeration<String> run() {
                    return PageContextImpl.this.doGetAttributeNamesInScope(scope);
                }
            });
        }
        return this.doGetAttributeNamesInScope(scope);
    }

    private Enumeration<String> doGetAttributeNamesInScope(int scope) {
        switch (scope) {
            case 1: {
                return Collections.enumeration(this.attributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw JasperMessages.MESSAGES.cannotUseSessionScope();
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw JasperMessages.MESSAGES.invalidScope();
    }

    public void removeAttribute(final String name) {
        if (name == null) {
            throw JasperMessages.MESSAGES.nullAttributeName();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    PageContextImpl.this.doRemoveAttribute(name);
                    return null;
                }
            });
        } else {
            this.doRemoveAttribute(name);
        }
    }

    private void doRemoveAttribute(String name) {
        this.removeAttribute(name, 1);
        this.removeAttribute(name, 2);
        if (this.session != null) {
            try {
                this.removeAttribute(name, 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.removeAttribute(name, 4);
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        Throwable t = JspRuntimeLibrary.getThrowable(this.request);
        if (t != null && !(t instanceof Exception)) {
            t = new JspException(t);
        }
        return (Exception)t;
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String relativeUrlPath) {
        String path = relativeUrlPath;
        if (!path.startsWith("/")) {
            String uri = (String)this.request.getAttribute("jakarta.servlet.include.servlet_path");
            if (uri == null) {
                uri = ((HttpServletRequest)this.request).getServletPath();
            }
            String baseURI = uri.substring(0, uri.lastIndexOf(47));
            path = baseURI + '/' + path;
        }
        return path;
    }

    public void include(String relativeUrlPath) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, this.out, true);
    }

    public void include(final String relativeUrlPath, final boolean flush) throws ServletException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        PageContextImpl.this.doInclude(relativeUrlPath, flush);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw (ServletException)ex;
            }
        } else {
            this.doInclude(relativeUrlPath, flush);
        }
    }

    private void doInclude(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, relativeUrlPath, this.out, flush);
    }

    @Deprecated
    public VariableResolver getVariableResolver() {
        return new VariableResolverImpl(this.getELContext());
    }

    public void forward(final String relativeUrlPath) throws ServletException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        PageContextImpl.this.doForward(relativeUrlPath);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw (ServletException)ex;
            }
        } else {
            this.doForward(relativeUrlPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doForward(String relativeUrlPath) throws ServletException, IOException {
        try {
            this.out.clear();
            this.baseOut.clear();
        }
        catch (IOException ex) {
            throw JasperMessages.MESSAGES.illegalClearAfterFlush(ex);
        }
        while (this.response instanceof ServletResponseWrapperInclude) {
            this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
        }
        String path = this.getAbsolutePathRelativeToContext(relativeUrlPath);
        String includeUri = (String)this.request.getAttribute("jakarta.servlet.include.servlet_path");
        if (includeUri != null) {
            this.request.removeAttribute("jakarta.servlet.include.servlet_path");
        }
        try {
            this.context.getRequestDispatcher(path).forward(this.request, this.response);
        }
        finally {
            if (includeUri != null) {
                this.request.setAttribute("jakarta.servlet.include.servlet_path", (Object)includeUri);
            }
        }
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter pushBody(Writer writer) {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] newOuts = new BodyContentImpl[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                newOuts[i] = this.outs[i];
            }
            newOuts[this.depth] = new BodyContentImpl(this.out);
            this.outs = newOuts;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        return this.outs[this.depth];
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("jakarta.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    @Deprecated
    public ExpressionEvaluator getExpressionEvaluator() {
        return new ExpressionEvaluatorImpl(this.applicationContext.getExpressionFactory());
    }

    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    public void handlePageException(final Throwable t) throws IOException, ServletException {
        if (t == null) {
            throw JasperMessages.MESSAGES.nullThrowable();
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        PageContextImpl.this.doHandlePageException(t);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw (ServletException)ex;
            }
        } else {
            this.doHandlePageException(t);
        }
    }

    private void doHandlePageException(Throwable t) throws IOException, ServletException {
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("jakarta.servlet.jsp.jspException", (Object)t);
            this.request.setAttribute("jakarta.servlet.error.status_code", (Object)new Integer(500));
            this.request.setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("jakarta.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException ise) {
                this.include(this.errorPageURL);
            }
            Object newException = this.request.getAttribute("jakarta.servlet.error.exception");
            if (newException != null && newException == t) {
                this.request.removeAttribute("jakarta.servlet.error.exception");
            }
        } else {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            Throwable rootCause = null;
            if (t instanceof JspException || t instanceof ELException || t instanceof jakarta.servlet.jsp.el.ELException) {
                rootCause = t.getCause();
            }
            if (rootCause != null) {
                throw new ServletException(t.getClass().getName() + ": " + t.getMessage(), rootCause);
            }
            throw new ServletException(t);
        }
        this.request.removeAttribute("jakarta.servlet.error.status_code");
        this.request.removeAttribute("jakarta.servlet.error.request_uri");
        this.request.removeAttribute("jakarta.servlet.error.servlet_name");
        this.request.removeAttribute("jakarta.servlet.jsp.jspException");
    }

    public static Object proprietaryEvaluate(String expression, Class<?> expectedType, PageContext pageContext, ProtectedFunctionMapper functionMap) throws ELException {
        ExpressionFactory exprFactory = jspf.getJspApplicationContext(pageContext.getServletContext()).getExpressionFactory();
        ELContext ctx = pageContext.getELContext();
        ELContextImpl ctxImpl = ctx instanceof JspContextWrapper.ELContextWrapper ? (ELContextImpl)((JspContextWrapper.ELContextWrapper)ctx).getWrappedELContext() : (ELContextImpl)ctx;
        ctxImpl.setFunctionMapper(functionMap);
        ValueExpression ve = exprFactory.createValueExpression(ctx, expression, expectedType);
        return ve.getValue(ctx);
    }

    public ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.applicationContext.createELContext((JspContext)this);
            if (this.servlet instanceof JspSourceDirectives && ((JspSourceDirectives)this.servlet).getErrorOnELNotFound()) {
                this.elContext.putContext(NotFoundELResolver.class, Boolean.TRUE);
            }
            if (this.servlet instanceof JspSourceImports) {
                Set<String> classImports;
                ImportHandler ih = this.elContext.getImportHandler();
                Set<String> packageImports = ((JspSourceImports)this.servlet).getPackageImports();
                if (packageImports != null) {
                    for (String packageImport : packageImports) {
                        ih.importPackage(packageImport);
                    }
                }
                if ((classImports = ((JspSourceImports)this.servlet).getClassImports()) != null) {
                    for (String classImport : classImports) {
                        ih.importClass(classImport);
                    }
                }
            }
        }
        return this.elContext;
    }
}

