/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.io.Format;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.microprofile.openapi.deployment.DeploymentConfiguration;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIHttpHandlerServiceConfigurator;
import org.wildfly.extension.microprofile.openapi.deployment.OpenAPIModelServiceConfigurator;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.DeploymentDefinition;

public class OpenAPIDocumentProcessor
implements DeploymentUnitProcessor {
    private static final String ENABLED = "mp.openapi.extensions.enabled";

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = context.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit)) {
            DeploymentOpenAPIConfiguration configuration = new DeploymentOpenAPIConfiguration(unit);
            OpenApiConfig config = configuration.getOpenApiConfig();
            if (!configuration.getProperty(ENABLED, Boolean.TRUE).booleanValue()) {
                MicroProfileOpenAPILogger.LOGGER.disabled(unit.getName());
                return;
            }
            if (config.modelReader() != null || config.filter() != null || configuration.getStaticFile() != null || OpenAPIDocumentProcessor.isRestful(unit)) {
                ServiceTarget target = context.getServiceTarget();
                OpenAPIModelServiceConfigurator configurator = new OpenAPIModelServiceConfigurator(unit, configuration);
                ServiceName modelServiceName = configurator.getServiceName();
                try {
                    if (context.getServiceRegistry().getService(modelServiceName) != null) {
                        throw new DuplicateServiceException(modelServiceName.getCanonicalName());
                    }
                    configurator.build(target).install();
                    new OpenAPIHttpHandlerServiceConfigurator(configurator).build(target).install();
                }
                catch (DuplicateServiceException e) {
                    MicroProfileOpenAPILogger.LOGGER.endpointAlreadyRegistered(configuration.getHostName(), unit.getName());
                }
            }
        }
    }

    private static boolean isRestful(DeploymentUnit unit) {
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (JaxrsAnnotations annotation : EnumSet.allOf(JaxrsAnnotations.class)) {
            if (index.getAnnotations(annotation.getDotName()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static class DeploymentOpenAPIConfiguration
    implements DeploymentConfiguration {
        private static final Map<Format, List<String>> STATIC_FILES = new EnumMap<Format, List<String>>(Format.class);
        private final Config config;
        private final OpenApiConfig openApiConfig;
        private final Map.Entry<VirtualFile, Format> staticFile;
        private final String serverName;
        private final String hostName;

        private static Map.Entry<VirtualFile, Format> findStaticFile(VirtualFile root) {
            for (Format format : EnumSet.of(Format.YAML, Format.JSON)) {
                for (String resource : STATIC_FILES.get(format)) {
                    VirtualFile file = root.getChild(resource);
                    if (!file.exists()) continue;
                    return Map.entry(file, format);
                }
            }
            return null;
        }

        DeploymentOpenAPIConfiguration(DeploymentUnit unit) {
            this.config = ConfigProvider.getConfig((ClassLoader)((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader());
            this.openApiConfig = OpenApiConfig.fromConfig((Config)this.config);
            this.staticFile = DeploymentOpenAPIConfiguration.findStaticFile(((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot());
            ModelNode model = ((DeploymentResourceSupport)unit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT)).getDeploymentSubsystemModel("undertow");
            this.serverName = model.get(DeploymentDefinition.SERVER.getName()).asString();
            this.hostName = model.get(DeploymentDefinition.VIRTUAL_HOST.getName()).asString();
        }

        @Override
        public <T> T getProperty(String name, T defaultValue) {
            return this.config.getOptionalValue(name, defaultValue.getClass()).orElse(defaultValue);
        }

        @Override
        public OpenApiConfig getOpenApiConfig() {
            return this.openApiConfig;
        }

        @Override
        public Map.Entry<VirtualFile, Format> getStaticFile() {
            return this.staticFile;
        }

        @Override
        public String getServerName() {
            return this.serverName;
        }

        @Override
        public String getHostName() {
            return this.hostName;
        }

        static {
            STATIC_FILES.put(Format.YAML, Arrays.asList("/META-INF/openapi.yaml", "/WEB-INF/classes/META-INF/openapi.yaml", "/META-INF/openapi.yml", "/WEB-INF/classes/META-INF/openapi.yml"));
            STATIC_FILES.put(Format.JSON, Arrays.asList("/META-INF/openapi.json", "/WEB-INF/classes/META-INF/openapi.json"));
        }
    }
}

