/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingDeque;
import mutiny.zero.internal.BufferingTubeBase;

public class LatestTube<T>
extends BufferingTubeBase<T> {
    private final LinkedBlockingDeque<T> overflowQueue;

    public LatestTube(Flow.Subscriber<? super T> subscriber, int bufferSize) {
        super(subscriber);
        this.overflowQueue = new LinkedBlockingDeque(bufferSize);
    }

    @Override
    Queue<T> overflowQueue() {
        return this.overflowQueue;
    }

    @Override
    protected void handleItem(T item) {
        if (this.outstandingRequests() > 0L) {
            this.dispatchQueue.offer(item);
            this.drainLoop();
        } else if (!this.overflowQueue.offer(item)) {
            this.overflowQueue.remove();
            this.overflowQueue.offer(item);
        }
    }
}

