/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerServiceMetaData;
import org.jboss.as.ejb3.timerservice.TimerServiceMetaDataSchema;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaData;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.Versioned;

public class TimerServiceMetaDataParser
extends AbstractEJBBoundMetaDataParser<TimerServiceMetaData> {
    private final TimerServiceMetaDataSchema schema;

    public TimerServiceMetaDataParser(TimerServiceMetaDataSchema schema) {
        this.schema = schema;
    }

    public TimerServiceMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (this.schema != TimerServiceMetaDataSchema.CURRENT) {
            EjbLogger.ROOT_LOGGER.deprecatedNamespace(reader.getNamespaceURI(), reader.getLocalName());
        }
        TimerServiceMetaData metaData = new TimerServiceMetaData();
        this.processElements(metaData, reader, propertyReplacer);
        return metaData;
    }

    protected void processElement(TimerServiceMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (this.schema.getNamespace().getUri().equals(reader.getNamespaceURI())) {
            switch (reader.getLocalName()) {
                case "persistence-store-name": {
                    metaData.setDataStoreName(TimerServiceMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    break;
                }
                case "persistent-timer-management": {
                    if (this.schema.since((Versioned)TimerServiceMetaDataSchema.VERSION_2_0)) {
                        metaData.setPersistentTimerManagementProvider(TimerServiceMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                        break;
                    }
                }
                case "transient-timer-management": {
                    if (this.schema.since((Versioned)TimerServiceMetaDataSchema.VERSION_2_0)) {
                        metaData.setTransientTimerManagementProvider(TimerServiceMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                        break;
                    }
                }
                default: {
                    throw TimerServiceMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
        } else {
            super.processElement((AbstractEJBBoundMetaData)metaData, reader, propertyReplacer);
        }
    }
}

