/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

class EJBDefaultSecurityDomainWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    private final AttributeDefinition attributeDefinition;
    private final AtomicReference<String> defaultSecurityDomainName;

    EJBDefaultSecurityDomainWriteHandler(AttributeDefinition attributeDefinition, AtomicReference<String> defaultSecurityDomainName) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
        this.defaultSecurityDomainName = defaultSecurityDomainName;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateDefaultSecurityDomainDeploymentProcessor(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateDefaultSecurityDomainDeploymentProcessor(context, restored);
    }

    private void updateDefaultSecurityDomainDeploymentProcessor(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode defaultSecurityDomainModelNode = this.attributeDefinition.resolveModelAttribute(context, model);
        String defaultSecurityDomainName = defaultSecurityDomainModelNode.isDefined() ? defaultSecurityDomainModelNode.asString() : null;
        this.defaultSecurityDomainName.set(defaultSecurityDomainName);
    }
}

