/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp;

import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class AmqpSenderOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, AmqpSenderOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "autoDrained": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAutoDrained((Boolean)member.getValue());
                    break;
                }
                case "capabilities": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setCapabilities(list);
                    break;
                }
                case "capabilitys": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCapability((String)item);
                        }
                    });
                    break;
                }
                case "dynamic": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDynamic((Boolean)member.getValue());
                    break;
                }
                case "linkName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLinkName((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(AmqpSenderOptions obj, JsonObject json) {
        AmqpSenderOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(AmqpSenderOptions obj, Map<String, Object> json) {
        json.put("autoDrained", obj.isAutoDrained());
        if (obj.getCapabilities() != null) {
            JsonArray array = new JsonArray();
            obj.getCapabilities().forEach(item -> array.add(item));
            json.put("capabilities", array);
        }
        json.put("dynamic", obj.isDynamic());
        if (obj.getLinkName() != null) {
            json.put("linkName", obj.getLinkName());
        }
    }
}

