/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;

public final class ResourceConfiguration {
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    static final String DISABLED_ATTRIBUTE_KEYS = "otel.experimental.resource.disabled.keys";

    public static Resource createEnvironmentResource() {
        return ResourceConfiguration.createEnvironmentResource((ConfigProperties)DefaultConfigProperties.create(Collections.emptyMap()));
    }

    public static Resource createEnvironmentResource(ConfigProperties config) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        try {
            for (Map.Entry entry : config.getMap(ATTRIBUTE_PROPERTY).entrySet()) {
                resourceAttributes.put((String)entry.getKey(), URLDecoder.decode((String)entry.getValue(), StandardCharsets.UTF_8.displayName()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException("Unable to decode resource attributes.", (Throwable)e);
        }
        String serviceName = config.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(ResourceAttributes.SERVICE_NAME, (Object)serviceName);
        }
        return Resource.create((Attributes)resourceAttributes.build(), (String)"https://opentelemetry.io/schemas/1.20.0");
    }

    static Resource configureResource(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Resource result = Resource.getDefault();
        HashSet enabledProviders = new HashSet(config.getList("otel.java.enabled.resource.providers"));
        HashSet disabledProviders = new HashSet(config.getList("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : spiHelper.loadOrdered(ResourceProvider.class)) {
            if (!enabledProviders.isEmpty() && !enabledProviders.contains(resourceProvider.getClass().getName()) || disabledProviders.contains(resourceProvider.getClass().getName()) || resourceProvider instanceof ConditionalResourceProvider && !((ConditionalResourceProvider)resourceProvider).shouldApply(config, result)) continue;
            result = result.merge(resourceProvider.createResource(config));
        }
        result = ResourceConfiguration.filterAttributes(result, config);
        return resourceCustomizer.apply((Resource)result, config);
    }

    static Resource filterAttributes(Resource resource, ConfigProperties configProperties) {
        HashSet disabledKeys = new HashSet(configProperties.getList(DISABLED_ATTRIBUTE_KEYS));
        ResourceBuilder builder = resource.toBuilder().removeIf(attributeKey -> disabledKeys.contains(attributeKey.getKey()));
        if (resource.getSchemaUrl() != null) {
            builder.setSchemaUrl(resource.getSchemaUrl());
        }
        return builder.build();
    }

    private ResourceConfiguration() {
    }
}

