/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.GetDataSourceClassInfoOperationHandler;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public class GetInstalledDriverOperationHandler
implements OperationStepHandler {
    public static final GetInstalledDriverOperationHandler INSTANCE = new GetInstalledDriverOperationHandler();

    private GetInstalledDriverOperationHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String name = Constants.INSTALLED_DRIVER_NAME.validateOperation(operation).asString();
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry(false);
                    DriverRegistry driverRegistry = (DriverRegistry)registry.getRequiredService(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE).getValue();
                    ServiceModuleLoader serviceModuleLoader = (ServiceModuleLoader)registry.getRequiredService(Services.JBOSS_SERVICE_MODULE_LOADER).getValue();
                    ModelNode result = new ModelNode();
                    InstalledDriver driver = driverRegistry.getInstalledDriver(name);
                    ModelNode driverNode = new ModelNode();
                    driverNode.get(Constants.INSTALLED_DRIVER_NAME.getName()).set(driver.getDriverName());
                    if (driver.isFromDeployment()) {
                        driverNode.get(Constants.DEPLOYMENT_NAME.getName()).set(driver.getDriverName());
                        driverNode.get(Constants.DRIVER_MODULE_NAME.getName());
                        driverNode.get(Constants.MODULE_SLOT.getName());
                        driverNode.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName());
                        driverNode.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName());
                    } else {
                        driverNode.get(Constants.DEPLOYMENT_NAME.getName());
                        driverNode.get(Constants.DRIVER_MODULE_NAME.getName()).set(driver.getModuleName().getName());
                        driverNode.get(Constants.MODULE_SLOT.getName()).set(driver.getModuleName() != null ? driver.getModuleName().getSlot() : "");
                        driverNode.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).set(driver.getDataSourceClassName() != null ? driver.getDataSourceClassName() : "");
                        driverNode.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).set(driver.getXaDataSourceClassName() != null ? driver.getXaDataSourceClassName() : "");
                    }
                    driverNode.get(Constants.DATASOURCE_CLASS_INFO.getName()).set(GetDataSourceClassInfoOperationHandler.dsClsInfoNode(serviceModuleLoader, driver.getModuleName(), driver.getDataSourceClassName(), driver.getXaDataSourceClassName()));
                    driverNode.get(Constants.DRIVER_CLASS_NAME.getName()).set(driver.getDriverClassName());
                    driverNode.get(Constants.DRIVER_MAJOR_VERSION.getName()).set(driver.getMajorVersion());
                    driverNode.get(Constants.DRIVER_MINOR_VERSION.getName()).set(driver.getMinorVersion());
                    driverNode.get(Constants.JDBC_COMPLIANT.getName()).set(driver.isJdbcCompliant());
                    result.add(driverNode);
                    context.getResult().set(result);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

