/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.server.infinispan.provider.AutoCloseableServiceProviderRegistry;
import org.wildfly.clustering.server.infinispan.provider.SimpleServiceProviderRegistration;

public class LocalServiceProviderRegistry<T>
implements AutoCloseableServiceProviderRegistry<T> {
    private final Set<T> services = ConcurrentHashMap.newKeySet();
    private final Group group;

    public LocalServiceProviderRegistry(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        this.services.add(service);
        return new SimpleServiceProviderRegistration<T>(service, this, () -> this.services.remove(service));
    }

    public ServiceProviderRegistration<T> register(T service, ServiceProviderRegistration.Listener listener) {
        return this.register(service);
    }

    public Set<Node> getProviders(T service) {
        return this.services.contains(service) ? Collections.singleton(this.getGroup().getLocalMember()) : Collections.emptySet();
    }

    public Set<T> getServices() {
        return Collections.unmodifiableSet(this.services);
    }

    @Override
    public void close() {
    }
}

