/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.domain.http.server.ConsoleAvailabilityService;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.FutureServiceContainer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.ServerPathManagerService;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.git.GitContentRepository;
import org.jboss.as.server.deployment.ContentCleanerService;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.RemoteFileRepositoryService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.version.ProductConfig;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.AsyncFuture;

final class ApplicationServerService
implements org.jboss.msc.service.Service<AsyncFuture<ServiceContainer>> {
    private final List<ServiceActivator> extraServices;
    private final Bootstrap.Configuration configuration;
    private final RunningModeControl runningModeControl;
    private final ControlledProcessState processState;
    private final SuspendController suspendController;
    private final boolean standalone;
    private final boolean selfContained;
    private volatile FutureServiceContainer futureContainer;
    private volatile long startTime;

    ApplicationServerService(List<ServiceActivator> extraServices, Bootstrap.Configuration configuration, ControlledProcessState processState, SuspendController suspendController) {
        this.extraServices = extraServices;
        this.configuration = configuration;
        this.runningModeControl = configuration.getRunningModeControl();
        this.startTime = configuration.getStartTime();
        this.standalone = configuration.getServerEnvironment().isStandalone();
        this.selfContained = configuration.getServerEnvironment().isSelfContained();
        this.processState = processState;
        this.suspendController = suspendController;
    }

    public synchronized void start(StartContext context) throws StartException {
        Object sb;
        Bootstrap.Configuration configuration = this.configuration;
        ServerEnvironment serverEnvironment = configuration.getServerEnvironment();
        ProductConfig config = serverEnvironment.getProductConfig();
        String prettyVersion = config.getPrettyVersionString();
        ServerLogger.AS_ROOT_LOGGER.serverStarting(prettyVersion);
        if (System.getSecurityManager() != null) {
            ServerLogger.AS_ROOT_LOGGER.securityManagerEnabled();
        }
        if (ServerLogger.CONFIG_LOGGER.isDebugEnabled()) {
            Properties properties = System.getProperties();
            StringBuilder b = new StringBuilder(8192);
            b.append(ServerLogger.ROOT_LOGGER.configuredSystemPropertiesLabel());
            for (String string : new TreeSet<String>(properties.stringPropertyNames())) {
                String propVal;
                String string2 = propVal = string.toLowerCase(Locale.ROOT).contains("password") ? "<redacted>" : properties.getProperty(string, "<undefined>");
                if (string.toLowerCase(Locale.ROOT).equals("sun.java.command") && !propVal.isEmpty()) {
                    Pattern pattern = Pattern.compile("(-D(?:[^ ])+=)((?:[^ ])+)");
                    Matcher matcher = pattern.matcher(propVal);
                    sb = new StringBuffer(propVal.length());
                    while (matcher.find()) {
                        if (!matcher.group(1).contains("password")) continue;
                        matcher.appendReplacement((StringBuffer)sb, Matcher.quoteReplacement(matcher.group(1) + "<redacted>"));
                    }
                    matcher.appendTail((StringBuffer)sb);
                    propVal = ((StringBuffer)sb).toString();
                }
                if (string.toLowerCase(Locale.ROOT).equals("wildfly.config.url") && !propVal.isEmpty()) {
                    ServerLogger.CONFIG_LOGGER.wildflyConfigUrlIsSet(string + " = " + propVal);
                }
                b.append("\n\t").append(string).append(" = ").append(propVal);
            }
            ServerLogger.CONFIG_LOGGER.debug(b);
            ServerLogger.CONFIG_LOGGER.debugf(ServerLogger.ROOT_LOGGER.vmArgumentsLabel(this.getVMArguments()), new Object[0]);
            if (ServerLogger.CONFIG_LOGGER.isTraceEnabled()) {
                b.setLength(0);
                Map<String, String> env = System.getenv();
                b.append(ServerLogger.ROOT_LOGGER.configuredSystemEnvironmentLabel());
                for (String key : new TreeSet<String>(env.keySet())) {
                    String envVal = key.toLowerCase(Locale.ROOT).contains("password") ? "<redacted>" : env.get(key);
                    b.append("\n\t").append(key).append(" = ").append(envVal);
                }
                ServerLogger.CONFIG_LOGGER.trace(b);
            }
        }
        final ServiceTarget serviceTarget = context.getChildTarget();
        ServiceController myController = context.getController();
        final ServiceContainer container = myController.getServiceContainer();
        this.futureContainer = new FutureServiceContainer();
        long l = this.startTime;
        if (l == -1L) {
            l = System.currentTimeMillis();
        } else {
            this.startTime = -1L;
        }
        CurrentServiceContainer.setServiceContainer(context.getController().getServiceContainer());
        BootstrapListener bootstrapListener = new BootstrapListener(container, l, serviceTarget, this.futureContainer, prettyVersion, serverEnvironment.getServerTempDir());
        bootstrapListener.getStabilityMonitor().addController(myController);
        if (this.standalone) {
            if (!this.selfContained) {
                if (serverEnvironment.useGit()) {
                    GitContentRepository.addService(serviceTarget, serverEnvironment.getGitRepository(), serverEnvironment.getServerContentDir(), serverEnvironment.getServerTempDir());
                } else {
                    ContentRepository.Factory.addService((ServiceTarget)serviceTarget, (File)serverEnvironment.getServerContentDir(), (File)serverEnvironment.getServerTempDir());
                }
            }
        } else {
            RemoteFileRepositoryService.addService(serviceTarget, serverEnvironment.getServerContentDir(), serverEnvironment.getServerTempDir());
        }
        ContentCleanerService.addService(serviceTarget, ServerService.JBOSS_SERVER_CLIENT_FACTORY, ServerService.JBOSS_SERVER_SCHEDULED_EXECUTOR);
        DeploymentMountProvider.Factory.addService(serviceTarget);
        ServiceModuleLoader.addService(serviceTarget, configuration);
        ExternalModuleService.addService(serviceTarget, ServerService.EXTERNAL_MODULE_CAPABILITY.getCapabilityServiceName());
        ConsoleAvailabilityService.addService((ServiceTarget)serviceTarget, bootstrapListener::logAdminConsole);
        ServerPathManagerService.addService(serviceTarget, new ServerPathManagerService(configuration.getCapabilityRegistry()), serverEnvironment);
        ServerService.addService(serviceTarget, configuration, this.processState, bootstrapListener, this.runningModeControl, configuration.getAuditLogger(), configuration.getAuthorizer(), configuration.getSecurityIdentitySupplier(), this.suspendController);
        ServiceActivatorContext serviceActivatorContext = new ServiceActivatorContext(){

            public ServiceTarget getServiceTarget() {
                return serviceTarget;
            }

            public ServiceRegistry getServiceRegistry() {
                return container;
            }
        };
        for (ServiceActivator activator : this.extraServices) {
            activator.activate(serviceActivatorContext);
        }
        ServerEnvironmentService.addService(serverEnvironment, serviceTarget);
        sb = serviceTarget.addService(Services.JBOSS_PRODUCT_CONFIG_SERVICE);
        Consumer productConfigConsumer = sb.provides(new ServiceName[]{Services.JBOSS_PRODUCT_CONFIG_SERVICE});
        sb.setInstance(Service.newInstance((Consumer)productConfigConsumer, (Object)config));
        sb.install();
        if (ServerLogger.AS_ROOT_LOGGER.isDebugEnabled()) {
            long nanos = context.getElapsedTime();
            ServerLogger.AS_ROOT_LOGGER.debugf(prettyVersion + " root service started in %d.%06d ms", nanos / 1000000L, nanos % 1000000L);
        }
    }

    public synchronized void stop(StopContext context) {
        CurrentServiceContainer.setServiceContainer(null);
        String prettyVersion = this.configuration.getServerEnvironment().getProductConfig().getPrettyVersionString();
        ServerLogger.AS_ROOT_LOGGER.serverStopped(prettyVersion, (int)(context.getElapsedTime() / 1000000L));
        BootstrapListener.deleteStartupMarker(this.configuration.getServerEnvironment().getServerTempDir());
    }

    public AsyncFuture<ServiceContainer> getValue() throws IllegalStateException, IllegalArgumentException {
        return this.futureContainer;
    }

    private String getVMArguments() {
        StringBuilder result = new StringBuilder(1024);
        RuntimeMXBean rmBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = rmBean.getInputArguments();
        for (String arg : inputArguments) {
            result.append(arg).append(" ");
        }
        return result.toString();
    }
}

