/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerEntry;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationAddressPolicyManager
implements ActiveMQServerBindingPlugin,
ActiveMQServerAddressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ActiveMQServer server;
    protected final FederationReceiveFromAddressPolicy policy;
    protected final Map<FederationConsumerInfo, FederationConsumerEntry> remoteConsumers = new HashMap<FederationConsumerInfo, FederationConsumerEntry>();
    protected final FederationInternal federation;
    protected final Map<DivertBinding, Set<SimpleString>> matchingDiverts = new HashMap<DivertBinding, Set<SimpleString>>();
    private volatile boolean started;

    public FederationAddressPolicyManager(FederationInternal federation, FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        Objects.requireNonNull(federation, "The Federation instance cannot be null");
        Objects.requireNonNull(addressPolicy, "The Address match policy cannot be null");
        this.federation = federation;
        this.policy = addressPolicy;
        this.server = federation.getServer();
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.scanAllBindings();
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.remoteConsumers.forEach((k, v) -> v.getConsumer().close());
            this.remoteConsumers.clear();
            this.matchingDiverts.clear();
        }
    }

    public synchronized void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.started && this.policy.isEnableDivertBindings() && this.policy.test(addressInfo)) {
            try {
                this.server.getPostOffice().getDirectBindings(addressInfo.getName()).stream().filter(binding -> binding instanceof DivertBinding).forEach(this::afterAddBinding);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(addressInfo.getName(), (Throwable)e);
            }
        }
    }

    public synchronized void afterAddBinding(Binding binding) {
        if (this.started) {
            this.checkBindingForMatch(binding);
        }
    }

    public synchronized void beforeRemoveBinding(SimpleString bindingName, Transaction tx, boolean deleteData) {
        Binding binding = this.server.getPostOffice().getBinding(bindingName);
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
        if (binding instanceof QueueBinding) {
            this.tryRemoveDemandOnAddress(addressInfo);
            if (this.policy.isEnableDivertBindings()) {
                this.matchingDiverts.entrySet().forEach(entry -> {
                    SimpleString forwardAddress = ((DivertBinding)entry.getKey()).getDivert().getForwardAddress();
                    if (FederationAddressPolicyManager.isAddressInDivertForwards(binding.getAddress(), forwardAddress)) {
                        AddressInfo srcAddressInfo = this.server.getPostOffice().getAddressInfo(((DivertBinding)entry.getKey()).getAddress());
                        if (((Set)entry.getValue()).remove(((QueueBinding)binding).getQueue().getName())) {
                            this.tryRemoveDemandOnAddress(srcAddressInfo);
                        }
                    }
                });
            }
        } else if (this.policy.isEnableDivertBindings() || binding instanceof DivertBinding) {
            DivertBinding divertBinding = (DivertBinding)binding;
            Set<SimpleString> matchingQueues = this.matchingDiverts.remove(binding);
            if (matchingQueues != null) {
                try {
                    matchingQueues.forEach(queueName -> this.tryRemoveDemandOnAddress(addressInfo));
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.federationBindingsLookupError(divertBinding.getDivert().getForwardAddress(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void tryRemoveDemandOnAddress(AddressInfo addressInfo) {
        FederationConsumerInfo consumerInfo = this.createConsumerInfo(addressInfo);
        FederationConsumerEntry entry = this.remoteConsumers.get(consumerInfo);
        if (entry != null && entry.reduceDemand()) {
            FederationConsumerInternal federationConsuner = entry.getConsumer();
            try {
                this.signalBeforeCloseFederationConsumer(federationConsuner);
                federationConsuner.close();
                this.signalAfterCloseFederationConsumer(federationConsuner);
            }
            finally {
                this.remoteConsumers.remove(consumerInfo);
            }
        }
    }

    protected final void scanAllBindings() {
        this.server.getPostOffice().getAllBindings().filter(bind -> bind instanceof QueueBinding || this.policy.isEnableDivertBindings() && bind instanceof DivertBinding).forEach(bind -> this.checkBindingForMatch((Binding)bind));
    }

    protected final void checkBindingForMatch(Binding binding) {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
            this.reactIfBindingMatchesPolicy(addressInfo, queueBinding);
            this.reactIfQueueBindingMatchesAnyDivertTarget(queueBinding);
        } else if (binding instanceof DivertBinding) {
            this.reactIfAnyQueueBindingMatchesDivertTarget((DivertBinding)binding);
        }
    }

    protected final void reactIfAnyQueueBindingMatchesDivertTarget(DivertBinding divertBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
        if (!this.testIfAddressMatchesPolicy(addressInfo)) {
            return;
        }
        if (this.matchingDiverts.get(divertBinding) == null) {
            HashSet matchingQueues = new HashSet();
            this.matchingDiverts.put(divertBinding, matchingQueues);
            SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
            SimpleString[] forwardAddresses = forwardAddress.split(',');
            try {
                for (SimpleString forward : forwardAddresses) {
                    this.server.getPostOffice().getBindingsForAddress(forward).getBindings().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(queueBinding -> {
                        if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                            return;
                        }
                        if (this.reactIfBindingMatchesPolicy(addressInfo, (QueueBinding)queueBinding)) {
                            matchingQueues.add(queueBinding.getQueue().getName());
                        }
                    });
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(forwardAddress, (Throwable)e);
            }
        }
    }

    protected final void reactIfQueueBindingMatchesAnyDivertTarget(QueueBinding queueBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        SimpleString queueAddress = queueBinding.getAddress();
        SimpleString queueName = queueBinding.getQueue().getName();
        this.matchingDiverts.entrySet().forEach(e -> {
            SimpleString forwardAddress = ((DivertBinding)e.getKey()).getDivert().getForwardAddress();
            DivertBinding divertBinding = (DivertBinding)e.getKey();
            if (!((Set)e.getValue()).contains(queueName) && FederationAddressPolicyManager.isAddressInDivertForwards(queueAddress, forwardAddress)) {
                if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                    return;
                }
                AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
                if (this.reactIfBindingMatchesPolicy(addressInfo, queueBinding)) {
                    ((Set)e.getValue()).add(queueName);
                }
            }
        });
    }

    private static boolean isAddressInDivertForwards(SimpleString queueAddress, SimpleString forwardAddress) {
        SimpleString[] forwardAddresses;
        for (SimpleString forward : forwardAddresses = forwardAddress.split(',')) {
            if (!queueAddress.equals((Object)forward)) continue;
            return true;
        }
        return false;
    }

    protected final boolean reactIfBindingMatchesPolicy(AddressInfo address, QueueBinding binding) {
        if (this.testIfAddressMatchesPolicy(address)) {
            logger.trace("Federation Address Policy matched on for demand on address: {} : binding: {}", (Object)address, (Object)binding);
            FederationConsumerInfo consumerInfo = this.createConsumerInfo(address);
            if (this.remoteConsumers.containsKey(consumerInfo)) {
                logger.trace("Federation Address Policy manager found existing demand for address: {}", (Object)address);
                this.remoteConsumers.get(consumerInfo).addDemand();
            } else {
                if (this.isPluginBlockingFederationConsumerCreate(address)) {
                    return false;
                }
                if (this.isPluginBlockingFederationConsumerCreate(binding.getQueue())) {
                    return false;
                }
                logger.trace("Federation Address Policy manager creating remote consumer for address: {}", (Object)address);
                this.signalBeforeCreateFederationConsumer(consumerInfo);
                FederationConsumerInternal queueConsumer = this.createFederationConsumer(consumerInfo);
                FederationConsumerEntry entry = this.createConsumerEntry(queueConsumer);
                queueConsumer.setRemoteClosedHandler(closedConsumer -> {
                    FederationAddressPolicyManager federationAddressPolicyManager = this;
                    synchronized (federationAddressPolicyManager) {
                        try {
                            this.remoteConsumers.remove(closedConsumer.getConsumerInfo());
                        }
                        finally {
                            closedConsumer.close();
                        }
                    }
                });
                this.remoteConsumers.put(consumerInfo, entry);
                queueConsumer.start();
                this.signalAfterCreateFederationConsumer(queueConsumer);
            }
            return true;
        }
        return false;
    }

    protected boolean testIfAddressMatchesPolicy(AddressInfo addressInfo) {
        return this.policy.test(addressInfo);
    }

    protected abstract FederationConsumerInfo createConsumerInfo(AddressInfo var1);

    protected FederationConsumerEntry createConsumerEntry(FederationConsumerInternal consumer) {
        return new FederationConsumerEntry(consumer);
    }

    protected abstract FederationConsumerInternal createFederationConsumer(FederationConsumerInfo var1);

    protected abstract void signalBeforeCreateFederationConsumer(FederationConsumerInfo var1);

    protected abstract void signalAfterCreateFederationConsumer(FederationConsumer var1);

    protected abstract void signalBeforeCloseFederationConsumer(FederationConsumer var1);

    protected abstract void signalAfterCloseFederationConsumer(FederationConsumer var1);

    protected abstract boolean isPluginBlockingFederationConsumerCreate(AddressInfo var1);

    protected abstract boolean isPluginBlockingFederationConsumerCreate(Divert var1, Queue var2);

    protected abstract boolean isPluginBlockingFederationConsumerCreate(Queue var1);
}

