/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.WrappedMessage;

public final class ContinuousQueryResult {
    private final ResultType resultType;
    private final byte[] key;
    private final byte[] value;
    private final Object[] projection;

    public ContinuousQueryResult(ResultType resultType, byte[] key, byte[] value, Object[] projection) {
        this.resultType = resultType;
        this.key = key;
        this.value = value;
        this.projection = projection;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public String toString() {
        return "ContinuousQueryResult{resultType=" + String.valueOf((Object)this.resultType) + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ", projection=" + Arrays.toString(this.projection) + "}";
    }

    public static enum ResultType {
        JOINING,
        UPDATED,
        LEAVING;


        static final class Marshaller
        implements EnumMarshaller<ResultType> {
            Marshaller() {
            }

            public ResultType decode(int enumValue) {
                switch (enumValue) {
                    case 0: {
                        return LEAVING;
                    }
                    case 1: {
                        return JOINING;
                    }
                    case 2: {
                        return UPDATED;
                    }
                }
                return null;
            }

            public int encode(ResultType resultType) throws IllegalArgumentException {
                switch (resultType.ordinal()) {
                    case 2: {
                        return 0;
                    }
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                }
                throw new IllegalArgumentException("Unexpected ResultType value : " + String.valueOf((Object)resultType));
            }

            public Class<ResultType> getJavaClass() {
                return ResultType.class;
            }

            public String getTypeName() {
                return "org.infinispan.query.remote.client.ContinuousQueryResult.ResultType";
            }
        }
    }

    static final class Marshaller
    implements MessageMarshaller<ContinuousQueryResult> {
        Marshaller() {
        }

        public ContinuousQueryResult readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            ResultType type = (ResultType)((Object)reader.readObject("resultType", ResultType.class));
            byte[] key = reader.readBytes("key");
            byte[] value = reader.readBytes("value");
            List projection = (List)reader.readCollection("projection", new ArrayList(), WrappedMessage.class);
            Object[] p = null;
            if (!projection.isEmpty()) {
                p = new Object[projection.size()];
                int j = 0;
                for (WrappedMessage m : projection) {
                    p[j++] = m.getValue();
                }
            }
            return new ContinuousQueryResult(type, key, value, p);
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ContinuousQueryResult continuousQueryResult) throws IOException {
            writer.writeObject("resultType", (Object)continuousQueryResult.getResultType(), ResultType.class);
            writer.writeBytes("key", continuousQueryResult.getKey());
            if (continuousQueryResult.getProjection() == null) {
                writer.writeBytes("value", continuousQueryResult.getValue());
            } else {
                Object[] p = new WrappedMessage[continuousQueryResult.getProjection().length];
                for (int i = 0; i < p.length; ++i) {
                    p[i] = new WrappedMessage(continuousQueryResult.getProjection()[i]);
                }
                writer.writeArray("projection", p, WrappedMessage.class);
            }
        }

        public Class<ContinuousQueryResult> getJavaClass() {
            return ContinuousQueryResult.class;
        }

        public String getTypeName() {
            return "org.infinispan.query.remote.client.ContinuousQueryResult";
        }
    }
}

