/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.publish;

import io.undertow.predicate.Predicate;
import jakarta.servlet.Servlet;
import java.io.File;
import java.security.AccessController;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.jboss.as.webservices.config.ServerConfigFactoryImpl;
import org.jboss.as.webservices.deployers.AllowWSRequestPredicate;
import org.jboss.as.webservices.deployers.EndpointServiceDeploymentAspect;
import org.jboss.as.webservices.deployers.deployment.DeploymentAspectsProvider;
import org.jboss.as.webservices.deployers.deployment.WSDeploymentBuilder;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.publish.WSEndpointDeploymentUnit;
import org.jboss.as.webservices.service.EndpointService;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.ws.common.deployment.DeploymentAspectManagerImpl;
import org.jboss.ws.common.deployment.EndpointHandlerDeploymentAspect;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.invocation.InvocationHandlerJAXWS;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFServlet;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class EndpointPublisherImpl
implements EndpointPublisher {
    private final WebHost host;
    private final boolean runningInService;
    private static List<DeploymentAspect> publisherDepAspects = null;
    private static List<DeploymentAspect> depAspects = null;

    protected EndpointPublisherImpl(WebHost host) {
        this(host, false);
    }

    protected EndpointPublisherImpl(WebHost host, boolean runningInService) {
        this.host = host;
        this.runningInService = runningInService;
    }

    protected EndpointPublisherImpl(boolean runningInService) {
        this(null, runningInService);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap) throws Exception {
        return this.publish((ServiceTarget)EndpointPublisherImpl.currentServiceContainer(), context, loader, urlPatternToClassNameMap, null, null, null, null);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata) throws Exception {
        return this.publish((ServiceTarget)EndpointPublisherImpl.currentServiceContainer(), context, loader, urlPatternToClassNameMap, null, metadata, null, null);
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata) throws Exception {
        return this.publish((ServiceTarget)EndpointPublisherImpl.currentServiceContainer(), context, loader, urlPatternToClassNameMap, null, metadata, jbwsMetadata, null);
    }

    protected Context publish(ServiceTarget target, String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, JBossWebMetaData jbwmd, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata, CapabilityServiceSupport capabilityServiceSupport) throws Exception {
        DeploymentUnit unit = this.doPrepare(context, loader, urlPatternToClassNameMap, jbwmd, metadata, jbwsMetadata, capabilityServiceSupport);
        this.doDeploy(target, unit);
        return this.doPublish(target, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeploymentUnit doPrepare(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap, JBossWebMetaData jbwmd, WebservicesMetaData metadata, JBossWebservicesMetaData jbwsMetadata, CapabilityServiceSupport capabilityServiceSupport) {
        ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        WSEndpointDeploymentUnit unit = new WSEndpointDeploymentUnit(loader, context, urlPatternToClassNameMap, jbwmd, metadata, jbwsMetadata, capabilityServiceSupport);
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            WSDeploymentBuilder.getInstance().build(unit);
            WSEndpointDeploymentUnit wSEndpointDeploymentUnit = unit;
            return wSEndpointDeploymentUnit;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeploy(ServiceTarget target, DeploymentUnit unit) {
        List<DeploymentAspect> aspects = this.getDeploymentAspects();
        ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        Deployment dep = null;
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            dep = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
            dep.addAttachment(ServiceTarget.class, (Object)target);
            DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
            dam.setDeploymentAspects(aspects);
            dam.deploy(dep);
        }
        finally {
            if (dep != null) {
                dep.removeAttachment(ServiceTarget.class);
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
        }
    }

    protected Context doPublish(ServiceTarget target, DeploymentUnit unit) throws Exception {
        Deployment deployment = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        List endpoints = deployment.getService().getEndpoints();
        if (!this.runningInService) {
            ServiceRegistry registry = unit.getServiceRegistry();
            final CountDownLatch latch = new CountDownLatch(endpoints.size());
            LifecycleListener listener = new LifecycleListener(){

                public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                    if (event == LifecycleEvent.UP) {
                        latch.countDown();
                        controller.removeListener((LifecycleListener)this);
                    }
                }
            };
            for (Endpoint ep : endpoints) {
                ServiceName serviceName = EndpointService.getServiceName(unit, ep.getShortName());
                registry.getRequiredService(serviceName).addListener(listener);
            }
            latch.await();
        }
        deployment.addAttachment(WebDeploymentController.class, (Object)EndpointPublisherImpl.startWebApp(this.host, unit));
        return new Context(((JBossWebMetaData)unit.getAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY)).getContextRoot(), endpoints);
    }

    private static WebDeploymentController startWebApp(WebHost host, DeploymentUnit unit) throws Exception {
        WebDeploymentController handle;
        WebDeploymentBuilder deployment = new WebDeploymentBuilder();
        try {
            JBossWebMetaData jbwebMD = (JBossWebMetaData)unit.getAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
            deployment.setContextRoot(jbwebMD.getContextRoot());
            File docBase = new File(ServerConfigFactoryImpl.getConfig().getServerTempDir(), jbwebMD.getContextRoot());
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            deployment.setDocumentRoot(docBase);
            deployment.setClassLoader((ClassLoader)unit.getAttachment(WSAttachmentKeys.CLASSLOADER_KEY));
            deployment.addAllowedRequestPredicate((Predicate)new AllowWSRequestPredicate());
            EndpointPublisherImpl.addServlets(jbwebMD, deployment);
            handle = host.addWebDeployment(deployment);
            handle.create();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.createContextPhaseFailed(e);
        }
        try {
            handle.start();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.startContextPhaseFailed(e);
        }
        return handle;
    }

    private static void addServlets(JBossWebMetaData jbwebMD, WebDeploymentBuilder deployment) {
        for (JBossServletMetaData smd : jbwebMD.getServlets()) {
            String sc = smd.getServletClass();
            if (!sc.equals(WSFServlet.class.getName())) continue;
            ServletBuilder servletBuilder = new ServletBuilder();
            String servletName = smd.getServletName();
            List params = smd.getInitParam();
            List urlPatterns = null;
            for (ServletMappingMetaData smmd : jbwebMD.getServletMappings()) {
                if (!smmd.getServletName().equals(servletName)) continue;
                urlPatterns = smmd.getUrlPatterns();
                servletBuilder.addUrlMappings((Collection)urlPatterns);
                break;
            }
            WSFServlet wsfs = new WSFServlet();
            servletBuilder.setServletName(servletName);
            servletBuilder.setServlet((Servlet)wsfs);
            servletBuilder.setServletClass(WSFServlet.class);
            for (ParamValueMetaData param : params) {
                servletBuilder.addInitParam(param.getParamName(), param.getParamValue());
            }
            deployment.addServlet(servletBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Context context) throws Exception {
        List eps = context.getEndpoints();
        if (eps == null || eps.isEmpty()) {
            return;
        }
        Deployment dep = ((Endpoint)eps.get(0)).getService().getDeployment();
        try {
            this.stopWebApp(dep);
        }
        finally {
            this.undeploy(dep);
        }
    }

    protected void undeploy(DeploymentUnit unit) throws Exception {
        this.undeploy((Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(Deployment deployment) throws Exception {
        List<DeploymentAspect> aspects = this.getDeploymentAspects();
        ClassLoader origClassLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
            dam.setDeploymentAspects(aspects);
            dam.undeploy(deployment);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)origClassLoader);
        }
    }

    protected void stopWebApp(Deployment deployment) throws Exception {
        WebDeploymentController context;
        try {
            context = (WebDeploymentController)deployment.getAttachment(WebDeploymentController.class);
            context.stop();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.stopContextPhaseFailed(e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            throw WSLogger.ROOT_LOGGER.destroyContextPhaseFailed(e);
        }
    }

    private List<DeploymentAspect> getDeploymentAspects() {
        return this.runningInService ? EndpointPublisherImpl.getReplacedDeploymentAspects() : EndpointPublisherImpl.getPublisherDeploymentAspects();
    }

    private static synchronized List<DeploymentAspect> getReplacedDeploymentAspects() {
        if (depAspects == null) {
            depAspects = new LinkedList<DeploymentAspect>();
            List<DeploymentAspect> serverAspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
            for (DeploymentAspect aspect : serverAspects) {
                if (aspect instanceof EndpointHandlerDeploymentAspect) {
                    depAspects.add(aspect);
                    ForceJAXWSInvocationHandlerDeploymentAspect handlerAspect = new ForceJAXWSInvocationHandlerDeploymentAspect();
                    depAspects.add((DeploymentAspect)handlerAspect);
                    continue;
                }
                depAspects.add(aspect);
            }
        }
        return depAspects;
    }

    private static synchronized List<DeploymentAspect> getPublisherDeploymentAspects() {
        if (publisherDepAspects == null) {
            publisherDepAspects = new LinkedList<DeploymentAspect>();
            List<DeploymentAspect> serverAspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
            for (DeploymentAspect aspect : serverAspects) {
                if (aspect instanceof EndpointServiceDeploymentAspect) {
                    EndpointServiceDeploymentAspect a = (EndpointServiceDeploymentAspect)aspect;
                    EndpointServiceDeploymentAspect clone = (EndpointServiceDeploymentAspect)a.clone();
                    clone.setStopServices(true);
                    publisherDepAspects.add((DeploymentAspect)clone);
                    continue;
                }
                if (aspect instanceof EndpointHandlerDeploymentAspect) {
                    publisherDepAspects.add(aspect);
                    ForceJAXWSInvocationHandlerDeploymentAspect handlerAspect = new ForceJAXWSInvocationHandlerDeploymentAspect();
                    publisherDepAspects.add((DeploymentAspect)handlerAspect);
                    continue;
                }
                publisherDepAspects.add(aspect);
            }
        }
        return publisherDepAspects;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    static class ForceJAXWSInvocationHandlerDeploymentAspect
    extends AbstractDeploymentAspect {
        public void start(Deployment dep) {
            for (Endpoint ep : dep.getService().getEndpoints()) {
                ep.setInvocationHandler((InvocationHandler)new InvocationHandlerJAXWS());
            }
        }
    }
}

