/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy;

import io.narayana.lra.client.internal.proxy.InvalidLRAStateException;
import io.narayana.lra.client.internal.proxy.ProxyService;
import io.narayana.lra.proxy.logging.LRAProxyLogger;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;

@ApplicationScoped
@Path(value="lraproxy")
public class ParticipantProxyResource {
    static final String LRA_PROXY_PATH = "lraproxy";
    @Inject
    private ProxyService proxyService;

    @Path(value="{lraId}/{pId}/complete")
    @PUT
    public Response complete(@PathParam(value="lraId") String lraId, @PathParam(value="pId") String participantId, String participantData) throws URISyntaxException, UnsupportedEncodingException {
        return this.proxyService.notifyParticipant(this.toURI(lraId, true), participantId, participantData, false);
    }

    @Path(value="{lraId}/{pId}/compensate")
    @PUT
    public Response compensate(@PathParam(value="lraId") String lraId, @PathParam(value="pId") String participantId, String participantData) throws URISyntaxException, UnsupportedEncodingException {
        return this.proxyService.notifyParticipant(this.toURI(lraId, true), participantId, participantData, true);
    }

    @Path(value="{lraId}/{pId}")
    @DELETE
    public void forget(@PathParam(value="lraId") String lraId, @PathParam(value="pId") String participantId) throws URISyntaxException, UnsupportedEncodingException {
        this.proxyService.notifyForget(this.toURI(lraId, true), participantId);
    }

    @Path(value="{lraId}/{pId}")
    @GET
    public String status(@PathParam(value="lraId") String lraId, @PathParam(value="pId") String participantId) throws UnsupportedEncodingException, InvalidLRAStateException {
        try {
            return this.proxyService.getStatus(this.toURI(lraId, true), participantId).name();
        }
        catch (URISyntaxException e) {
            String logMsg = LRAProxyLogger.i18NLogger.error_gettingParticipantStatus(participantId, lraId, e);
            LRAProxyLogger.logger.error((Object)logMsg);
            throw new InvalidLRAStateException(logMsg);
        }
    }

    private URI toURI(String url, boolean decode) throws URISyntaxException, UnsupportedEncodingException {
        if (url == null) {
            return null;
        }
        if (decode) {
            url = URLDecoder.decode(url, "UTF-8");
        }
        return new URI(url);
    }
}

