/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.hibernate.search.backend.elasticsearch.gson.impl.GsonUtils;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchAllPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchNonePredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBooleanPredicate
extends AbstractElasticsearchPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String MUST_PROPERTY_NAME = "must";
    private static final String MUST_NOT_PROPERTY_NAME = "must_not";
    private static final String SHOULD_PROPERTY_NAME = "should";
    private static final String FILTER_PROPERTY_NAME = "filter";
    private static final JsonAccessor<String> MINIMUM_SHOULD_MATCH_ACCESSOR = JsonAccessor.root().property("minimum_should_match").asString();
    private final List<ElasticsearchSearchPredicate> mustClauses;
    private final List<ElasticsearchSearchPredicate> mustNotClauses;
    private final List<ElasticsearchSearchPredicate> shouldClauses;
    private final List<ElasticsearchSearchPredicate> filterClauses;
    private final Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    private ElasticsearchBooleanPredicate(Builder builder) {
        super(builder);
        this.mustClauses = builder.mustClauses;
        this.mustNotClauses = builder.mustNotClauses;
        this.shouldClauses = builder.shouldClauses;
        this.filterClauses = builder.filterClauses;
        this.minimumShouldMatchConstraints = builder.minimumShouldMatchConstraints;
        builder.mustClauses = null;
        builder.mustNotClauses = null;
        builder.shouldClauses = null;
        builder.filterClauses = null;
        builder.minimumShouldMatchConstraints = null;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.checkNestableWithin(expectedParentNestedPath, this.mustClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.shouldClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.filterClauses);
        this.checkNestableWithin(expectedParentNestedPath, this.mustNotClauses);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        this.contributeClauses(context, innerObject, MUST_PROPERTY_NAME, this.mustClauses);
        this.contributeClauses(context, innerObject, MUST_NOT_PROPERTY_NAME, this.mustNotClauses);
        this.contributeClauses(context, innerObject, SHOULD_PROPERTY_NAME, this.shouldClauses);
        this.contributeClauses(context, innerObject, FILTER_PROPERTY_NAME, this.filterClauses);
        if (this.isOnlyMustNot() && !super.hasNoModifiers()) {
            JsonObject matchAllClause = new JsonObject();
            ElasticsearchMatchAllPredicate.MATCH_ALL_ACCESSOR.set(matchAllClause, new JsonObject());
            GsonUtils.setOrAppendToArray(innerObject, MUST_PROPERTY_NAME, (JsonElement)matchAllClause);
        }
        if (this.minimumShouldMatchConstraints != null) {
            MINIMUM_SHOULD_MATCH_ACCESSOR.set(innerObject, this.formatMinimumShouldMatchConstraints(this.minimumShouldMatchConstraints));
        }
        outerObject.add("bool", (JsonElement)innerObject);
        return outerObject;
    }

    private void contributeClauses(PredicateRequestContext context, JsonObject innerObject, String occurProperty, List<ElasticsearchSearchPredicate> clauses) {
        if (clauses == null) {
            return;
        }
        for (ElasticsearchSearchPredicate clause : clauses) {
            GsonUtils.setOrAppendToArray(innerObject, occurProperty, (JsonElement)clause.toJsonQuery(context));
        }
    }

    private void checkNestableWithin(String expectedParentNestedPath, List<ElasticsearchSearchPredicate> clauses) {
        if (clauses == null) {
            return;
        }
        for (ElasticsearchSearchPredicate clause : clauses) {
            clause.checkNestableWithin(expectedParentNestedPath);
        }
    }

    private String formatMinimumShouldMatchConstraints(Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, MinimumShouldMatchConstraint>> iterator = minimumShouldMatchConstraints.entrySet().iterator();
        Map.Entry<Integer, MinimumShouldMatchConstraint> entry = iterator.next();
        Integer ignoreConstraintCeiling = entry.getKey();
        MinimumShouldMatchConstraint constraint = entry.getValue();
        if (ignoreConstraintCeiling.equals(0) && minimumShouldMatchConstraints.size() == 1) {
            constraint.appendTo(builder, null);
            return builder.toString();
        }
        entry.getValue().appendTo(builder, ignoreConstraintCeiling);
        while (iterator.hasNext()) {
            entry = iterator.next();
            ignoreConstraintCeiling = entry.getKey();
            constraint = entry.getValue();
            builder.append(' ');
            constraint.appendTo(builder, ignoreConstraintCeiling);
        }
        return builder.toString();
    }

    private boolean isOnlyMustNot() {
        return !(this.mustNotClauses == null || this.mustNotClauses.isEmpty() || this.mustClauses != null && !this.mustClauses.isEmpty() || this.shouldClauses != null && !this.shouldClauses.isEmpty() || this.filterClauses != null && !this.filterClauses.isEmpty());
    }

    private boolean hasOnlyOneMustNotClause() {
        return this.isOnlyMustNot() && this.mustNotClauses.size() == 1;
    }

    @Override
    protected boolean hasNoModifiers() {
        return this.minimumShouldMatchConstraints == null && super.hasNoModifiers();
    }

    static class Builder
    extends AbstractElasticsearchPredicate.AbstractBuilder
    implements BooleanPredicateBuilder {
        private List<ElasticsearchSearchPredicate> mustClauses;
        private List<ElasticsearchSearchPredicate> mustNotClauses;
        private List<ElasticsearchSearchPredicate> shouldClauses;
        private List<ElasticsearchSearchPredicate> filterClauses;
        private Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public void must(SearchPredicate clause) {
            if (this.mustClauses == null) {
                this.mustClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.mustClauses.add(ElasticsearchSearchPredicate.from(this.scope, clause));
        }

        public void mustNot(SearchPredicate clause) {
            if (this.mustNotClauses == null) {
                this.mustNotClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.mustNotClauses.add(ElasticsearchSearchPredicate.from(this.scope, clause));
        }

        public void should(SearchPredicate clause) {
            if (this.shouldClauses == null) {
                this.shouldClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.shouldClauses.add(ElasticsearchSearchPredicate.from(this.scope, clause));
        }

        public void filter(SearchPredicate clause) {
            if (this.filterClauses == null) {
                this.filterClauses = new ArrayList<ElasticsearchSearchPredicate>();
            }
            this.filterClauses.add(ElasticsearchSearchPredicate.from(this.scope, clause));
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(matchingClausesNumber, null));
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(null, matchingClausesPercent));
        }

        public boolean hasClause() {
            return this.mustClauses != null || this.shouldClauses != null || this.mustNotClauses != null || this.filterClauses != null;
        }

        private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, MinimumShouldMatchConstraint constraint) {
            MinimumShouldMatchConstraint previous;
            if (this.minimumShouldMatchConstraints == null) {
                this.minimumShouldMatchConstraints = new TreeMap<Integer, MinimumShouldMatchConstraint>();
            }
            if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
                throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
            }
        }

        public SearchPredicate build() {
            if (!this.hasClause()) {
                return new ElasticsearchMatchNonePredicate(this);
            }
            this.optimizeClauseCollection(this.mustClauses, this::mustNot);
            this.optimizeClauseCollection(this.mustNotClauses, this::must);
            this.checkAndClearClauseCollections();
            if (this.hasNoModifiers()) {
                if (this.hasOnlyOneMustClause()) {
                    return this.mustClauses.get(0);
                }
                if (this.hasOnlyOneShouldClause()) {
                    return this.shouldClauses.get(0);
                }
            }
            if (this.minimumShouldMatchConstraints == null && this.hasAtLeastOneMustOrFilterPredicate()) {
                this.minimumShouldMatchNumber(0, 0);
            }
            return new ElasticsearchBooleanPredicate(this);
        }

        private void optimizeClauseCollection(List<ElasticsearchSearchPredicate> collection, Consumer<ElasticsearchSearchPredicate> newCollection) {
            if (collection != null) {
                Iterator<ElasticsearchSearchPredicate> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ElasticsearchSearchPredicate clause = iterator.next();
                    if (!(clause instanceof ElasticsearchBooleanPredicate) || !((ElasticsearchBooleanPredicate)clause).hasOnlyOneMustNotClause() || !((ElasticsearchBooleanPredicate)clause).hasNoModifiers()) continue;
                    iterator.remove();
                    newCollection.accept(((ElasticsearchBooleanPredicate)clause).mustNotClauses.get(0));
                }
            }
        }

        private void checkAndClearClauseCollections() {
            if (this.mustClauses != null && this.mustClauses.isEmpty()) {
                this.mustClauses = null;
            }
            if (this.mustNotClauses != null && this.mustNotClauses.isEmpty()) {
                this.mustNotClauses = null;
            }
        }

        private boolean hasAtLeastOneMustOrFilterPredicate() {
            return this.mustClauses != null || this.filterClauses != null;
        }

        private boolean hasOnlyOneMustClause() {
            return !(this.mustClauses == null || this.mustClauses.size() != 1 || this.mustNotClauses != null && !this.mustNotClauses.isEmpty() || this.shouldClauses != null && !this.shouldClauses.isEmpty() || this.filterClauses != null && !this.filterClauses.isEmpty());
        }

        private boolean hasOnlyOneShouldClause() {
            return !(this.shouldClauses == null || this.shouldClauses.size() != 1 || this.mustNotClauses != null && !this.mustNotClauses.isEmpty() || this.mustClauses != null && !this.mustClauses.isEmpty() || this.filterClauses != null && !this.filterClauses.isEmpty());
        }

        @Override
        protected boolean hasNoModifiers() {
            return this.minimumShouldMatchConstraints == null && super.hasNoModifiers();
        }
    }

    private static final class MinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        void appendTo(StringBuilder builder, Integer ignoreConstraintCeiling) {
            if (ignoreConstraintCeiling != null) {
                builder.append(ignoreConstraintCeiling).append('<');
            }
            if (this.matchingClausesNumber != null) {
                builder.append(this.matchingClausesNumber);
            } else {
                builder.append(this.matchingClausesPercent).append('%');
            }
        }
    }
}

