/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.search.mapper.orm.loading.spi.EntityGraphHint;
import org.hibernate.search.mapper.orm.loading.spi.LoadingMappingContext;
import org.hibernate.search.util.common.impl.Contracts;

public final class MutableEntityLoadingOptions {
    private int fetchSize;
    private List<EntityGraphHint<?>> entityGraphHints;

    public MutableEntityLoadingOptions(LoadingMappingContext mappingContext) {
        this.fetchSize = mappingContext.fetchSize();
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize(int fetchSize) {
        Contracts.assertStrictlyPositive((int)fetchSize, (String)"fetchSize");
        this.fetchSize = fetchSize;
    }

    public EntityGraphHint<?> entityGraphHintOrNullForType(EntityMappingType entityMappingType) {
        if (this.entityGraphHints == null || this.entityGraphHints.isEmpty()) {
            return null;
        }
        for (EntityMappingType testedType = entityMappingType; testedType != null; testedType = testedType.getSuperMappingType()) {
            for (EntityGraphHint<?> entityGraphHint : this.entityGraphHints) {
                EntityDomainType graphedType = (EntityDomainType)entityGraphHint.graph.getGraphedType();
                if (!graphedType.getHibernateEntityName().equals(testedType.getEntityName())) continue;
                return entityGraphHint;
            }
        }
        return null;
    }

    public void entityGraphHint(EntityGraphHint<?> entityGraphHint, boolean replaceExisting) {
        if (this.entityGraphHints == null) {
            this.entityGraphHints = new ArrayList();
        } else if (replaceExisting) {
            this.entityGraphHints.clear();
        }
        if (entityGraphHint == null) {
            return;
        }
        this.entityGraphHints.add(entityGraphHint);
    }
}

