/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DefaultResourceRemoveDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.wildfly.common.Assert;

public class SimpleResourceDefinition
implements ResourceDefinition {
    private static final EnumSet<OperationEntry.Flag> RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM);
    private static final RuntimeCapability[] NO_CAPABILITIES = new RuntimeCapability[0];
    private final PathElement pathElement;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DescriptionProvider descriptionProvider;
    private final OperationStepHandler addHandler;
    private final OperationStepHandler removeHandler;
    private final OperationEntry.Flag addRestartLevel;
    private final OperationEntry.Flag removeRestartLevel;
    private final boolean runtime;
    private volatile DeprecationData deprecationData;
    private final boolean orderedChild;
    private final RuntimeCapability[] capabilities;
    private final Set<RuntimeCapability> incorporatingCapabilities;
    private final Set<CapabilityReferenceRecorder> requirements;
    private final List<AccessConstraintDefinition> accessConstraints;
    private final int minOccurs;
    private final int maxOccurs;
    private boolean feature;
    private final RuntimePackageDependency[] additionalPackages;

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
        this(new Parameters(pathElement, descriptionResolver).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        this(new Parameters(pathElement, descriptionResolver).setAddHandler(addHandler).setRemoveHandler(removeHandler).setAddRestartLevel(SimpleResourceDefinition.restartLevelForAdd(addHandler)).setRemoveRestartLevel(SimpleResourceDefinition.restartLevelForRemove(removeHandler)));
    }

    public SimpleResourceDefinition(Parameters parameters) {
        this.pathElement = parameters.pathElement;
        this.descriptionResolver = parameters.descriptionResolver;
        this.addHandler = parameters.addHandler;
        this.removeHandler = parameters.removeHandler;
        this.addRestartLevel = parameters.addRestartLevel;
        this.removeRestartLevel = parameters.removeRestartLevel;
        this.deprecationData = parameters.deprecationData;
        this.runtime = parameters.runtime;
        this.orderedChild = parameters.orderedChildResource;
        this.descriptionProvider = parameters.descriptionProvider;
        this.capabilities = parameters.capabilities != null ? parameters.capabilities : NO_CAPABILITIES;
        this.incorporatingCapabilities = parameters.incorporatingCapabilities;
        this.accessConstraints = parameters.accessConstraints != null ? Arrays.asList(parameters.accessConstraints) : Collections.emptyList();
        this.requirements = new HashSet<CapabilityReferenceRecorder>(parameters.requirements);
        this.minOccurs = parameters.minOccurs;
        this.maxOccurs = parameters.maxOccurs;
        this.feature = parameters.feature;
        this.additionalPackages = parameters.additionalPackages;
    }

    private static OperationEntry.Flag restartLevelForAdd(OperationStepHandler addHandler) {
        return addHandler instanceof AbstractBoottimeAddStepHandler || addHandler instanceof ReloadRequiredAddStepHandler ? OperationEntry.Flag.RESTART_ALL_SERVICES : OperationEntry.Flag.RESTART_NONE;
    }

    private static OperationEntry.Flag restartLevelForRemove(OperationStepHandler removeHandler) {
        return removeHandler instanceof ReloadRequiredRemoveStepHandler ? OperationEntry.Flag.RESTART_ALL_SERVICES : OperationEntry.Flag.RESTART_RESOURCE_SERVICES;
    }

    @Override
    public PathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        return this.descriptionProvider == null ? new DefaultResourceDescriptionProvider(resourceRegistration, this.descriptionResolver, this.getDeprecationData()) : this.descriptionProvider;
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        if (this.addHandler != null) {
            this.registerAddOperation(resourceRegistration, this.addHandler, this.addRestartLevel);
        }
        if (this.removeHandler != null) {
            this.registerRemoveOperation(resourceRegistration, this.removeHandler, this.removeRestartLevel);
        }
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        if (this.capabilities != null) {
            for (RuntimeCapability c : this.capabilities) {
                resourceRegistration.registerCapability(c);
            }
        }
        if (this.incorporatingCapabilities != null) {
            resourceRegistration.registerIncorporatingCapabilities(this.incorporatingCapabilities);
        }
        assert (this.requirements != null);
        resourceRegistration.registerRequirements(this.requirements);
    }

    @Override
    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        if (this.additionalPackages != null) {
            resourceRegistration.registerAdditionalRuntimePackages(this.additionalPackages);
        }
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return this.descriptionResolver;
    }

    protected AttributeDefinition[] getAddOperationParameters(ManagementResourceRegistration registration) {
        Stream<AttributeDefinition> attributes = registration.getAttributes(PathAddress.EMPTY_ADDRESS).values().stream().filter(AttributeAccess.Storage.CONFIGURATION).map(AttributeAccess::getAttributeDefinition).filter(Predicate.not(AttributeDefinition::isResourceOnly));
        if (registration.isOrderedChildResource()) {
            attributes = Stream.concat(Stream.of(DefaultResourceAddDescriptionProvider.INDEX), attributes);
        }
        return (AttributeDefinition[])attributes.toArray(AttributeDefinition[]::new);
    }

    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        DescriptionProvider descriptionProvider = handler instanceof DescriptionProvider ? (DescriptionProvider)((Object)handler) : new DefaultResourceAddDescriptionProvider(registration, this.descriptionResolver, this.orderedChild);
        SimpleOperationDefinition definition = new SimpleOperationDefinitionBuilder("add", this.descriptionResolver).setParameters(this.getAddOperationParameters(registration)).setDescriptionProvider(descriptionProvider).setEntryType(OperationEntry.EntryType.PUBLIC).withFlags(flags).build();
        registration.registerOperationHandler(definition, handler);
    }

    protected void registerRemoveOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        DescriptionProvider descriptionProvider = handler instanceof DescriptionProvider ? (DescriptionProvider)((Object)handler) : new DefaultResourceRemoveDescriptionProvider(this.descriptionResolver);
        SimpleOperationDefinition definition = new SimpleOperationDefinitionBuilder("remove", this.descriptionResolver).setDescriptionProvider(descriptionProvider).setEntryType(OperationEntry.EntryType.PUBLIC).withFlags(flags).build();
        registration.registerOperationHandler(definition, handler);
    }

    @Deprecated
    protected void registerAddOperation(ManagementResourceRegistration registration, AbstractAddStepHandler handler, OperationEntry.Flag ... flags) {
        this.registerAddOperation(registration, (OperationStepHandler)handler, flags);
    }

    @Deprecated
    protected void registerRemoveOperation(ManagementResourceRegistration registration, AbstractRemoveStepHandler handler, OperationEntry.Flag ... flags) {
        this.registerRemoveOperation(registration, (OperationStepHandler)handler, flags);
    }

    private static OperationEntry.Flag validateRestartLevel(String paramName, OperationEntry.Flag flag) {
        if (flag != null && !RESTART_FLAGS.contains((Object)flag)) {
            throw ControllerLogger.ROOT_LOGGER.invalidParameterValue(flag, paramName, RESTART_FLAGS);
        }
        return flag;
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        return SimpleOperationDefinitionBuilder.getFlagsSet(vararg);
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    protected void setDeprecated(ModelVersion since) {
        this.deprecationData = new DeprecationData(since);
    }

    protected DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    @Override
    public boolean isRuntime() {
        return this.runtime;
    }

    @Override
    public int getMinOccurs() {
        if (this.minOccurs == 0) {
            return ResourceDefinition.super.getMinOccurs();
        }
        return this.minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        if (this.maxOccurs == Integer.MAX_VALUE) {
            return ResourceDefinition.super.getMaxOccurs();
        }
        return this.maxOccurs;
    }

    @Override
    public boolean isOrderedChild() {
        return this.orderedChild;
    }

    @Override
    public boolean isFeature() {
        return this.feature;
    }

    public static class Parameters {
        private final PathElement pathElement;
        private ResourceDescriptionResolver descriptionResolver;
        private DescriptionProvider descriptionProvider;
        private OperationStepHandler addHandler;
        private OperationStepHandler removeHandler;
        private OperationEntry.Flag addRestartLevel = OperationEntry.Flag.RESTART_NONE;
        private OperationEntry.Flag removeRestartLevel = OperationEntry.Flag.RESTART_ALL_SERVICES;
        private boolean runtime;
        private DeprecationData deprecationData;
        private boolean orderedChildResource;
        private RuntimeCapability[] capabilities;
        private Set<RuntimeCapability> incorporatingCapabilities;
        private Set<CapabilityReferenceRecorder> requirements = new HashSet<CapabilityReferenceRecorder>();
        private AccessConstraintDefinition[] accessConstraints;
        private boolean feature = true;
        private int minOccurs = 0;
        private int maxOccurs = Integer.MAX_VALUE;
        private RuntimePackageDependency[] additionalPackages;

        public Parameters(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
            Assert.checkNotNullParam((String)"descriptionResolver", (Object)descriptionResolver);
            this.pathElement = pathElement;
            this.descriptionResolver = descriptionResolver;
        }

        public Parameters(PathElement pathElement, DescriptionProvider descriptionProvider) {
            Assert.checkNotNullParam((String)"descriptionProvider", (Object)descriptionProvider);
            this.pathElement = pathElement;
            this.descriptionProvider = descriptionProvider;
        }

        public Parameters setDescriptionResolver(ResourceDescriptionResolver descriptionResolver) {
            Assert.checkNotNullParam((String)"descriptionResolver", (Object)descriptionResolver);
            this.descriptionResolver = descriptionResolver;
            return this;
        }

        public Parameters setAddHandler(OperationStepHandler addHandler) {
            this.addHandler = addHandler;
            if (this.addRestartLevel == null) {
                this.addRestartLevel = SimpleResourceDefinition.restartLevelForAdd(addHandler);
            }
            return this;
        }

        public Parameters setRemoveHandler(OperationStepHandler removeHandler) {
            this.removeHandler = removeHandler;
            if (this.removeRestartLevel == null) {
                this.removeRestartLevel = SimpleResourceDefinition.restartLevelForRemove(removeHandler);
            }
            return this;
        }

        public Parameters setAddRestartLevel(OperationEntry.Flag addRestartLevel) {
            Assert.checkNotNullParam((String)"addRestartLevel", (Object)((Object)addRestartLevel));
            this.addRestartLevel = SimpleResourceDefinition.validateRestartLevel("addRestartLevel", addRestartLevel);
            return this;
        }

        public Parameters setRemoveRestartLevel(OperationEntry.Flag removeRestartLevel) {
            Assert.checkNotNullParam((String)"removeRestartLevel", (Object)((Object)removeRestartLevel));
            this.removeRestartLevel = SimpleResourceDefinition.validateRestartLevel("removeRestartLevel", removeRestartLevel);
            return this;
        }

        public Parameters setRuntime() {
            this.runtime = true;
            return this;
        }

        public Parameters setRuntime(boolean isRuntime) {
            this.runtime = isRuntime;
            return this;
        }

        public Parameters setDeprecationData(DeprecationData deprecationData) {
            this.deprecationData = deprecationData;
            return this;
        }

        public Parameters setDeprecatedSince(ModelVersion deprecatedSince) {
            Assert.checkNotNullParam((String)"deprecatedSince", (Object)deprecatedSince);
            this.deprecationData = new DeprecationData(deprecatedSince);
            return this;
        }

        public Parameters setOrderedChild() {
            this.orderedChildResource = true;
            return this;
        }

        public Parameters setCapabilities(RuntimeCapability ... capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Parameters setAdditionalPackages(RuntimePackageDependency ... additionalPackages) {
            this.additionalPackages = additionalPackages;
            return this;
        }

        public Parameters addCapabilities(RuntimeCapability ... capabilities) {
            if (this.capabilities == null) {
                this.setCapabilities(capabilities);
            } else if (capabilities != null && capabilities.length > 0) {
                RuntimeCapability[] combo = Arrays.copyOf(this.capabilities, this.capabilities.length + capabilities.length);
                System.arraycopy(capabilities, 0, combo, this.capabilities.length, capabilities.length);
                this.setCapabilities(combo);
            }
            return this;
        }

        public Parameters setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
            this.accessConstraints = accessConstraints;
            return this;
        }

        public Parameters addAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
            if (this.accessConstraints == null) {
                this.setAccessConstraints(accessConstraints);
            } else if (accessConstraints != null && accessConstraints.length > 0) {
                AccessConstraintDefinition[] combo = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + accessConstraints.length);
                System.arraycopy(accessConstraints, 0, combo, this.accessConstraints.length, accessConstraints.length);
                this.setAccessConstraints(combo);
            }
            return this;
        }

        public Parameters setMaxOccurs(int maxOccurs) {
            this.maxOccurs = maxOccurs;
            return this;
        }

        public Parameters setMinOccurs(int minOccurs) {
            this.minOccurs = minOccurs;
            return this;
        }

        public Parameters setFeature(boolean feature) {
            this.feature = feature;
            return this;
        }

        public Parameters setIncorporatingCapabilities(Set<RuntimeCapability> incorporatingCapabilities) {
            this.incorporatingCapabilities = incorporatingCapabilities;
            return this;
        }

        public Parameters addRequirement(String baseDependentName, Function<PathAddress, String[]> dependentDynamicNameMapper, String baseRequirementName, Function<PathAddress, String[]> requirementDynamicNameMapper) {
            this.requirements.add(new CapabilityReferenceRecorder.ResourceCapabilityReferenceRecorder(dependentDynamicNameMapper, baseDependentName, requirementDynamicNameMapper, baseRequirementName));
            return this;
        }

        public Parameters addIncorporatingCapabilities(Set<RuntimeCapability> incorporatingCapabilities) {
            if (this.incorporatingCapabilities == null) {
                this.setIncorporatingCapabilities(incorporatingCapabilities);
            } else if (incorporatingCapabilities != null && !incorporatingCapabilities.isEmpty()) {
                HashSet<RuntimeCapability> combo = new HashSet<RuntimeCapability>();
                combo.addAll(this.incorporatingCapabilities);
                combo.addAll(incorporatingCapabilities);
                this.setIncorporatingCapabilities(combo);
            }
            return this;
        }
    }
}

